/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.xml;

import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.exception.ConfigurationException;
import org.jboss.windup.config.parser.ElementHandler;
import org.jboss.windup.config.parser.NamespaceElementHandler;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.reporting.config.TechnologyTag;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.util.exception.WindupException;
import org.w3c.dom.Element;

@NamespaceElementHandler(elementName="technology-tag", namespace="http://windup.jboss.org/schema/jboss-ruleset")
public class TechnologyTagHandler
implements ElementHandler<Object> {
    public static final String TECHNOLOGY_TAG = "technology-tag";
    private static final String LEVEL = "level";

    public TechnologyTag processElement(ParserContext handlerManager, Element element) throws ConfigurationException {
        String tag = element.getTextContent();
        if (!StringUtils.isNotBlank((CharSequence)tag)) {
            throw new WindupException("Error, 'technology-tag' element must have non-empty content");
        }
        tag = tag.trim();
        TechnologyTagLevel issueCategory = TechnologyTagLevel.INFORMATIONAL;
        String category = element.getAttribute(LEVEL);
        if (StringUtils.isNotBlank((CharSequence)category)) {
            issueCategory = TechnologyTagLevel.valueOf((String)category);
        }
        return TechnologyTag.withName((String)tag).withTechnologyTagLevel(issueCategory);
    }
}

