/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.rules.rendering;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.PostFinalizePhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.performance.RulePhaseExecutionStatisticsModel;
import org.jboss.windup.graph.model.performance.RuleProviderExecutionStatisticsModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.RuleProviderExecutionStatisticsService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.PathUtil;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=PostFinalizePhase.class)
public class ExecutionTimeReportRuleProvider
extends AbstractRuleProvider {
    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        return ConfigurationBuilder.begin().addRule().perform((Operation)new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext context) {
                WindupConfigurationModel cfg = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
                String outputDir = cfg.getOutputPath().getFilePath();
                Path statsDir = Paths.get(outputDir, "stats");
                FileUtils.deleteQuietly((File)statsDir.toFile());
                PathUtil.createDirectory((Path)statsDir, (String)"stats folder");
                Path detailedExecutionStatsOutputPath = statsDir.resolve("detailed_stats.csv");
                ExecutionStatistics.get().serializeTimingData(detailedExecutionStatsOutputPath);
                Path ruleTimingOutputPath = statsDir.resolve("timing.txt");
                try (FileWriter fw = new FileWriter(ruleTimingOutputPath.toFile());){
                    Iterable ruleProviderStatModels = new RuleProviderExecutionStatisticsService(event.getGraphContext()).findAllOrderedByIndex();
                    fw.write("-----------------------------------------------------------\n");
                    fw.write("Rule execution timings:\n\n");
                    for (RuleProviderExecutionStatisticsModel model : ruleProviderStatModels) {
                        int ms = model.getTimeTaken();
                        fw.write(String.format("% 5d.%03d, %s\n", ms / 1000, ms % 1000, model.getRuleProviderID()));
                    }
                    fw.write("-----------------------------------------------------------\n\n");
                    fw.write("Phase execution timings:\n\n");
                    GraphService statsByPhaseService = new GraphService(event.getGraphContext(), RulePhaseExecutionStatisticsModel.class);
                    List rulePhaseStatModelIterable = statsByPhaseService.findAll();
                    ArrayList<RulePhaseExecutionStatisticsModel> rulePhaseStatModelList = new ArrayList<RulePhaseExecutionStatisticsModel>();
                    for (RulePhaseExecutionStatisticsModel model : rulePhaseStatModelIterable) {
                        rulePhaseStatModelList.add(model);
                    }
                    Collections.sort(rulePhaseStatModelList, RulePhaseExecutionStatisticsModel.BY_ORDER_EXECUTED);
                    for (RulePhaseExecutionStatisticsModel model : rulePhaseStatModelList) {
                        int ms = model.getTimeTaken();
                        fw.write(String.format("% 6d.%03d, %s\n", ms / 1000, ms % 1000, model.getRulePhase()));
                    }
                    fw.write("-----------------------------------------------------------\n");
                }
                catch (IOException e) {
                    throw new WindupException("Error creating output file: " + ruleTimingOutputPath + " due to: " + e.getMessage(), (Throwable)e);
                }
            }

            public String toString() {
                return "RenderRuleExecutionTimeReport";
            }
        });
    }
}

