/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.rules.generation.techreport;

import freemarker.ext.beans.StringModel;
import freemarker.template.TemplateModelException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.reporting.model.TagModel;
import org.jboss.windup.reporting.model.TechnologyUsageStatisticsModel;
import org.jboss.windup.reporting.service.TagGraphService;
import org.jboss.windup.util.ExecutionStatistics;

public class GetTechReportPunchCardStatsMethod
implements WindupFreeMarkerMethod {
    public static final Logger LOG = Logger.getLogger(GetTechReportPunchCardStatsMethod.class.getName());
    private static final String NAME = "getTechReportPunchCardStats";
    private GraphContext graphContext;

    public void setContext(GraphRewrite event) {
        this.graphContext = event.getGraphContext();
    }

    public String getMethodName() {
        return NAME;
    }

    public String getDescription() {
        return "Takes a " + ProjectModel.class.getSimpleName() + " as a parameter and returns Map<Long, Integer> where the key is the effort level and the value is the number of incidents at that particular level of effort.";
    }

    public Object exec(List arguments) throws TemplateModelException {
        ExecutionStatistics.get().begin(NAME);
        ProjectModel projectModel = null;
        if (arguments.size() >= 1) {
            StringModel projectArg = (StringModel)arguments.get(0);
            projectModel = (ProjectModel)projectArg.getWrappedObject();
        }
        MatrixAndAggregated result = this.computeProjectAndTagsMatrix(this.graphContext, projectModel);
        ExecutionStatistics.get().end(NAME);
        return result;
    }

    private MatrixAndAggregated computeProjectAndTagsMatrix(GraphContext graphContext, ProjectModel projectToCount) {
        GraphService service = new GraphService(graphContext, TagModel.class);
        TagModel sectorsHolderTag = (TagModel)service.getUniqueByProperty("name", (Object)"techreport-sectors:");
        if (null == sectorsHolderTag) {
            LOG.warning("Tech Report hierarchy definition TagModel not found, looked for tag name techreport-sectors:");
            return null;
        }
        HashMap<Long, Map<String, Integer>> matrix = new HashMap<Long, Map<String, Integer>>();
        HashMap<String, Integer> maximums = new HashMap<String, Integer>();
        HashMap<String, Integer> totals = new HashMap<String, Integer>();
        for (TagModel sectorTag : sectorsHolderTag.getDesignatedTags()) {
            for (TagModel techTag : sectorTag.getDesignatedTags()) {
                String tagName = techTag.getName();
                Map<Long, Integer> tagCountForAllApps = GetTechReportPunchCardStatsMethod.getTagCountForAllApps(graphContext, tagName);
                tagCountForAllApps.forEach((project, count) -> {
                    Map appTagCounts = matrix.computeIfAbsent((Long)project, k -> new HashMap());
                    appTagCounts.put(tagName, count);
                    maximums.put(tagName, Math.max(count, maximums.getOrDefault(tagName, 0)));
                    totals.put(tagName, count + totals.getOrDefault(tagName, 0));
                });
            }
        }
        return new MatrixAndAggregated(matrix, maximums, totals);
    }

    static Map<Long, Integer> getTagCountForAllApps(GraphContext graphContext, String subSectorTagName) {
        Set<String> subTagsNames = GetTechReportPunchCardStatsMethod.getSubTagNamesGraph(graphContext, subSectorTagName);
        Set<ProjectModel> apps = GetTechReportPunchCardStatsMethod.getAllApplications(graphContext);
        HashMap<Long, Integer> appToTechSectorCoveredTagsOccurrenceCount = new HashMap<Long, Integer>();
        for (ProjectModel app : apps) {
            int countSoFar = 0;
            Iterator statsIt = app.getElement().vertices(Direction.IN, new String[]{"stats.projectModel"});
            while (statsIt.hasNext()) {
                Vertex vStat = (Vertex)statsIt.next();
                TechnologyUsageStatisticsModel stat = (TechnologyUsageStatisticsModel)graphContext.getFramed().frameElement((Element)vStat, TechnologyUsageStatisticsModel.class);
                Set techStatTagsCoveredByGivenTag = stat.getTags().stream().filter(name -> subTagsNames.contains(name)).collect(Collectors.toSet());
                if (techStatTagsCoveredByGivenTag.isEmpty()) continue;
                countSoFar += stat.getOccurrenceCount();
            }
            appToTechSectorCoveredTagsOccurrenceCount.put((Long)app.getElement().id(), countSoFar);
        }
        return appToTechSectorCoveredTagsOccurrenceCount;
    }

    private static Set<String> getSubTagNamesGraph(GraphContext graphContext, String subSectorTagName) {
        TagGraphService tagService = new TagGraphService(graphContext);
        Set subTags = tagService.getDescendantTags(tagService.getTagByName(subSectorTagName));
        return subTags.stream().map(TagModel::getName).collect(Collectors.toSet());
    }

    private static Set<ProjectModel> getAllApplications(GraphContext graphContext) {
        HashSet<ProjectModel> apps = new HashSet<ProjectModel>();
        Iterable appProjects = graphContext.findAll(ProjectModel.class);
        for (ProjectModel appProject : appProjects) {
            apps.add(appProject);
        }
        return apps;
    }

    public static class MatrixAndAggregated {
        private Map<Long, Map<String, Integer>> countsOfTagsInApps;
        private Map<String, Integer> maximumsPerTag;
        private Map<String, Integer> totalsPerTag;

        public MatrixAndAggregated(Map<Long, Map<String, Integer>> countsOfTagsInApps, Map<String, Integer> maximumsPerTag, Map<String, Integer> totalsPerTag) {
            this.countsOfTagsInApps = countsOfTagsInApps;
            this.maximumsPerTag = maximumsPerTag;
            this.totalsPerTag = totalsPerTag;
        }

        public Map<Long, Map<String, Integer>> getCountsOfTagsInApps() {
            return this.countsOfTagsInApps;
        }

        public Map<String, Integer> getMaximumsPerTag() {
            return this.maximumsPerTag;
        }

        public Map<String, Integer> getTotalsPerTag() {
            return this.totalsPerTag;
        }
    }
}

