/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.rules.generation.techreport;

import freemarker.template.SimpleScalar;
import freemarker.template.TemplateModelException;
import java.util.List;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.reporting.service.TagGraphService;

public class GetTagModelByNameMethod
implements WindupFreeMarkerMethod {
    private GraphContext graphContext;

    public String getMethodName() {
        return "getTagModelByName";
    }

    public Object exec(List arguments) throws TemplateModelException {
        if (arguments.size() != 1) {
            throw new TemplateModelException("Expected one String argument - the name of the tag.");
        }
        SimpleScalar stringModel = (SimpleScalar)arguments.get(0);
        String tagName = stringModel.getAsString();
        return new TagGraphService(this.graphContext).getTagByName(tagName);
    }

    public String getDescription() {
        return "Returns the TagModel of the given name, or null if it doesn't exist.";
    }

    public void setContext(GraphRewrite event) {
        this.graphContext = event.getGraphContext();
    }
}

