/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.rules.generation.techreport;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.NumberModel;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.SimpleNumber;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;

public class GetLogarithmicDistribution
implements WindupFreeMarkerMethod {
    public static final Logger LOG = Logger.getLogger(GetLogarithmicDistribution.class.getName());
    private static final String NAME = "getLogaritmicDistribution";
    private static final double FLATTENER = 0.4;
    private static final double QUITE_A_LOT_FACTOR = 80.0;

    public String getMethodName() {
        return NAME;
    }

    public String getDescription() {
        return "Returns a logarithmic distribution usable for visualising ranges that tend to be wide-scale with exponential distribution.";
    }

    public Object exec(List arguments) throws TemplateModelException {
        if (arguments.size() < 2) {
            throw new TemplateModelException("getLogaritmicDistribution: Expected 2 arguments, count and maximum count.");
        }
        if (!(arguments.get(0) instanceof TemplateNumberModel)) {
            throw new TemplateModelException("getLogaritmicDistribution: Both arguments must be numbers, but the first was " + arguments.get(0).getClass().getName());
        }
        if (!(arguments.get(1) instanceof TemplateNumberModel)) {
            throw new TemplateModelException("getLogaritmicDistribution: Both arguments must be numbers, but the second was " + arguments.get(1).getClass().getName());
        }
        int count = ((TemplateNumberModel)arguments.get(0)).getAsNumber().intValue();
        if (count < 1) {
            return new SimpleNumber(0);
        }
        int maximum = ((TemplateNumberModel)arguments.get(1)).getAsNumber().intValue();
        if (maximum < 0) {
            throw new TemplateModelException("getLogaritmicDistributionMaximum must be at least 0, " + maximum);
        }
        if (count > maximum) {
            LOG.severe("Count " + count + " is larger than maximum " + maximum + ". Using the maximum as count.");
            count = maximum;
        }
        double ratio = (double)count / ((double)maximum + 80.0);
        double ratio2 = 1.0 + ratio * 598.8;
        double log10 = Math.log10(ratio2) / 3.0;
        return new NumberModel((Number)log10, (BeansWrapper)new DefaultObjectWrapper());
    }
}

