/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.rules.generation.techreport;

import java.util.HashMap;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.ReportGenerationPhase;
import org.jboss.windup.config.tags.TagServiceHolder;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.ProjectService;
import org.jboss.windup.reporting.model.ApplicationReportModel;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.reporting.model.TagModel;
import org.jboss.windup.reporting.model.TechReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.service.ApplicationReportService;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.reporting.service.TagGraphService;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=ReportGenerationPhase.class)
public class CreateTechReportRuleProvider
extends AbstractRuleProvider {
    private static final Logger LOG = Logger.getLogger(CreateTechReportRuleProvider.class.getName());
    private static final String TEMPLATE_PATH_PUNCH = "/reports/templates/techReport-punchCard.ftl";
    private static final String REPORT_NAME_PUNCH = "Technologies";
    private static final String REPORT_DESCRIPTION_PUNCH = "This report is a statistic of technologies occurrences in the input applications. It shows how the technologies are distributed and is mostly useful when analysing many applications.";
    private static final String TEMPLATE_PATH_BOXES = "/reports/templates/techReport-boxes.ftl";
    private static final String REPORT_NAME_BOXES = "Technologies";
    private static final String REPORT_DESCRIPTION_BOXES = "This report is a statistic of technologies occurrences in the input applications. It is an overview of what technologies are found in given project or a set of projects.";
    @Inject
    private TagServiceHolder tagServiceHolder;

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        return ConfigurationBuilder.begin().addRule().perform((Operation)new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext context) {
                new TagGraphService(event.getGraphContext()).feedTheWholeTagStructureToGraph(CreateTechReportRuleProvider.this.tagServiceHolder.getTagService());
            }
        }).withId("feedTagsToGraph").addRule().perform((Operation)new CreateTechReportPunchCardOperation()).withId("createTechReport");
    }

    private class CreateTechReportPunchCardOperation
    extends GraphOperation {
        private CreateTechReportPunchCardOperation() {
        }

        public void perform(GraphRewrite event, EvaluationContext evCtx) {
            TagGraphService tagGraphService = new TagGraphService(event.getGraphContext());
            TagModel sectorsTag = tagGraphService.getTagByName("techreport-sectors:");
            TagModel rowsTag = tagGraphService.getTagByName("techreport-rows:");
            if (null == sectorsTag) {
                LOG.severe("Tech report sectors tag, 'techreport-sectors:', not found. The technology report will not be rendered.");
                return;
            }
            if (null == rowsTag) {
                LOG.severe("Tech report rows tag, 'techreport-rows:', not found. The technology report will not be rendered.");
                return;
            }
            HashMap<String, TechReportModel> appProjectToReportMap = new HashMap<String, TechReportModel>();
            for (ProjectModel appModel : new ProjectService(event.getGraphContext()).getRootProjectModels()) {
                TechReportModel appTechReport = this.createTechReportBoxes(event.getGraphContext(), appModel);
                appTechReport.setSectorsHolderTag(sectorsTag);
                appTechReport.setRowsHolderTag(rowsTag);
                appProjectToReportMap.put(appModel.getElement().id().toString(), appTechReport);
            }
            TechReportModel reportPunch = this.createTechReportPunchCard(event.getGraphContext());
            reportPunch.setSectorsHolderTag(sectorsTag);
            reportPunch.setRowsHolderTag(rowsTag);
            reportPunch.setAppProjectIdToReportMap(appProjectToReportMap);
        }

        private TechReportModel createTechReportPunchCard(GraphContext graphContext) {
            TechReportModel report = this.createTechReportBase(graphContext);
            report.setReportName("Technologies");
            report.setTemplatePath(CreateTechReportRuleProvider.TEMPLATE_PATH_PUNCH);
            report.setDescription(CreateTechReportRuleProvider.REPORT_DESCRIPTION_PUNCH);
            report.setReportIconClass("fa fa-rocket");
            report.setDisplayInGlobalApplicationIndex(Boolean.valueOf(true));
            report.setDisplayInApplicationReportIndex(Boolean.valueOf(true));
            new ReportService(graphContext).setUniqueFilename((ReportModel)report, "techReport-punch", "html");
            return report;
        }

        private TechReportModel createTechReportBoxes(GraphContext graphContext, ProjectModel appModel) {
            TechReportModel report = this.createTechReportBase(graphContext);
            report.setProjectModel(appModel);
            report.setDisplayInGlobalApplicationIndex(Boolean.valueOf(false));
            report.setDisplayInApplicationReportIndex(Boolean.valueOf(true));
            report.setReportName("Technologies");
            report.setTemplatePath(CreateTechReportRuleProvider.TEMPLATE_PATH_BOXES);
            report.setDescription(CreateTechReportRuleProvider.REPORT_DESCRIPTION_BOXES);
            report.setReportIconClass("fa fa-rocket");
            new ReportService(graphContext).setUniqueFilename((ReportModel)report, "techReport-" + appModel.getName(), "html");
            return (TechReportModel)new GraphService(graphContext, TechReportModel.class).addTypeToModel((WindupVertexFrame)report);
        }

        private TechReportModel createTechReportBase(GraphContext graphContext) {
            ApplicationReportService applicationReportService = new ApplicationReportService(graphContext);
            ApplicationReportModel report = applicationReportService.create();
            report.setTemplateType(TemplateType.FREEMARKER);
            report.setMainApplicationReport(Boolean.valueOf(false));
            report.setReportPriority(103);
            return (TechReportModel)new GraphService(graphContext, TechReportModel.class).addTypeToModel((WindupVertexFrame)report);
        }
    }
}

