/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.rules.generation;

import java.util.List;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.PostReportGenerationPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.model.resource.SourceFileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.graph.traversal.ProjectModelTraversal;
import org.jboss.windup.reporting.SourceTypeResolver;
import org.jboss.windup.reporting.model.ApplicationReportModel;
import org.jboss.windup.reporting.model.FreeMarkerSourceReportModel;
import org.jboss.windup.reporting.model.ReportFileModel;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.model.source.SourceReportModel;
import org.jboss.windup.reporting.model.source.SourceReportToProjectEdgeModel;
import org.jboss.windup.reporting.service.ApplicationReportService;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.reporting.service.SourceReportService;
import org.jboss.windup.util.Logging;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=PostReportGenerationPhase.class)
public class CreateSourceReportRuleProvider
extends AbstractRuleProvider {
    private static final Logger LOG = Logging.get(CreateSourceReportRuleProvider.class);
    private static final String TEMPLATE = "/reports/templates/source.ftl";
    @Inject
    private Imported<SourceTypeResolver> resolvers;

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        GraphOperation addSourceReports = new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext context) {
                WindupConfigurationModel configurationModel = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
                ReportService reportService = new ReportService(event.getGraphContext());
                List inputApplications = configurationModel.getInputPaths();
                for (FileModel inputApplication : inputApplications) {
                    ProjectModelTraversal projectModelTraversal = new ProjectModelTraversal(inputApplication.getProjectModel());
                    CreateSourceReportRuleProvider.this.traverse(event, projectModelTraversal, reportService);
                }
            }

            public String toString() {
                return "AddSourceReport";
            }
        };
        return ConfigurationBuilder.begin().addRule().perform((Operation)addSourceReports);
    }

    private void traverse(GraphRewrite event, ProjectModelTraversal traversal, ReportService reportService) {
        for (FileModel fileModel : traversal.getCanonicalProject().getFileModels()) {
            if (!(fileModel instanceof SourceFileModel) || !((SourceFileModel)fileModel).isGenerateSourceReport()) continue;
            this.createSourceReport(event, traversal, reportService, fileModel);
        }
        for (ProjectModelTraversal child : traversal.getChildren()) {
            this.traverse(event, child, reportService);
        }
    }

    private void createSourceReport(GraphRewrite event, ProjectModelTraversal traversal, ReportService reportService, FileModel sourceFile) {
        ProjectModel application = traversal.getCurrent().getRootProjectModel();
        SourceReportService sourceReportService = new SourceReportService(event.getGraphContext());
        SourceReportModel sourceReportModel = sourceReportService.getSourceReportForFileModel(sourceFile);
        if (sourceReportModel != null) {
            for (SourceReportToProjectEdgeModel existing : sourceReportModel.getProjectEdges()) {
                if (!existing.getProjectModel().equals(application)) continue;
                return;
            }
            SourceReportToProjectEdgeModel toProjectEdge = sourceReportModel.addProjectModel(application);
            toProjectEdge.setFullPath(traversal.getFilePath(sourceFile));
            return;
        }
        sourceReportModel = (SourceReportModel)sourceReportService.create();
        ReportFileModel reportFileModel = (ReportFileModel)GraphService.addTypeToModel((GraphContext)event.getGraphContext(), (WindupVertexFrame)sourceFile, ReportFileModel.class);
        sourceReportModel.setSourceFileModel(reportFileModel);
        SourceReportToProjectEdgeModel toProjectEdge = sourceReportModel.addProjectModel(application);
        toProjectEdge.setFullPath(traversal.getFilePath(sourceFile));
        sourceReportModel.setReportName(sourceFile.getPrettyPath());
        sourceReportModel.setSourceType(this.resolveSourceType(sourceFile));
        sourceReportModel.setReportName(sourceFile.getFileName());
        sourceReportModel.setTemplatePath(TEMPLATE);
        sourceReportModel.setTemplateType(TemplateType.FREEMARKER);
        ApplicationReportService applicationReportService = new ApplicationReportService(event.getGraphContext());
        ApplicationReportModel mainAppReport = applicationReportService.getMainApplicationReportForFile(sourceFile);
        if (mainAppReport != null) {
            sourceReportModel.setParentReport((ReportModel)mainAppReport);
        }
        GraphService.addTypeToModel((GraphContext)event.getGraphContext(), (WindupVertexFrame)sourceReportModel, FreeMarkerSourceReportModel.class);
        reportService.setUniqueFilename((ReportModel)sourceReportModel, sourceFile.getFileName(), "html");
    }

    private String resolveSourceType(FileModel f) {
        for (SourceTypeResolver resolver : this.resolvers) {
            String resolvedType = resolver.resolveSourceType(f);
            if (resolvedType == null) continue;
            return resolvedType;
        }
        return "unknown";
    }
}

