/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.renderer.dot;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.jboss.windup.reporting.renderer.GraphWriter;
import org.jboss.windup.reporting.renderer.dot.DotConstants;
import org.jboss.windup.reporting.renderer.dot.DotWriter;
import org.jboss.windup.util.Logging;
import org.joox.JOOX;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class VizJSHtmlWriter
implements GraphWriter {
    private static Logger LOG = Logging.get(VizJSHtmlWriter.class);
    private final DotWriter writer;

    public VizJSHtmlWriter(Graph graph) {
        this.writer = new DotWriter(graph, "G", "qualifiedName", "", DotConstants.DotGraphType.DIGRAPH, "8pt");
    }

    public VizJSHtmlWriter(Graph graph, String vertexLabelProperty, String edgeLabel) {
        this.writer = new DotWriter(graph, "G", vertexLabelProperty, edgeLabel, DotConstants.DotGraphType.DIGRAPH, "8pt");
    }

    @Override
    public void writeGraph(Path outputDirectory) throws IOException {
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("vizjs/viz.js");
             FileOutputStream outputStream = new FileOutputStream(outputDirectory.resolve("viz.js").toFile());){
            IOUtils.copy((InputStream)is, (OutputStream)outputStream);
        }
        is = this.getClass().getClassLoader().getResourceAsStream("vizjs/HtmlTemplate.html");
        try {
            Path indexHTML = outputDirectory.resolve("index.html");
            try (FileOutputStream os = new FileOutputStream(indexHTML.toFile());){
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.writer.writeGraph(baos);
                String result = baos.toString();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("DOT: " + result);
                }
                try {
                    Document document = JOOX.$((InputStream)is).document();
                    JOOX.$((Document)document).find("#dot-source").append(result);
                    this.writeDocument(document, os);
                }
                catch (SAXException e) {
                    throw new IOException("Exception loading document.", e);
                }
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public void writeDocument(Document document, OutputStream os) throws IOException {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(os);
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new IOException("Exception writing to output stream.", e);
        }
    }
}

