/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.renderer.dot;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.jboss.windup.reporting.renderer.GraphDataSerializer;
import org.jboss.windup.reporting.renderer.dot.DotConstants;
import org.jboss.windup.util.exception.WindupException;

public class DotWriter
implements GraphDataSerializer {
    private final Graph graph;
    private String graphName = "G";
    private String vertexLabelProperty = "label";
    private DotConstants.DotGraphType graphType = DotConstants.DotGraphType.DIGRAPH;
    private String fontSize = "12pt";
    private String edgeLabel = "";

    public DotWriter(Graph graph) {
        this.graph = graph;
    }

    public DotWriter(Graph graph, String graphName, String vertexLabelProperty, String edgeLabel, DotConstants.DotGraphType graphType, String fontSize) {
        this.graph = graph;
        this.graphName = graphName;
        this.fontSize = fontSize;
        this.vertexLabelProperty = vertexLabelProperty;
        this.graphType = graphType;
        this.edgeLabel = edgeLabel;
    }

    @Override
    public void writeGraph(OutputStream os) throws IOException {
        this.writeGraphTag(os);
    }

    private void writeGraphTag(OutputStream os) throws IOException {
        String name = this.getDotSafeName(this.graphName);
        IOUtils.write((String)(this.graphType.getName() + " " + name + "{" + System.lineSeparator()), (OutputStream)os);
        this.writeGraphNodes(os);
        this.writeGraphEdges(os);
        IOUtils.write((String)"}", (OutputStream)os);
    }

    private void writeGraphEdges(OutputStream os) throws IOException {
        this.graph.edges(new Object[0]).forEachRemaining(edge -> {
            String label = this.edgeLabel;
            String source = edge.outVertex().id().toString();
            String target = edge.inVertex().id().toString();
            try {
                this.writeGraphEdge(label, source, target, os);
            }
            catch (IOException e) {
                throw new WindupException((Throwable)e);
            }
        });
    }

    private void writeGraphEdge(String label, String source, String target, OutputStream os) throws IOException {
        String startTag = this.getDotSafeName(source) + this.graphType.getEdge() + this.getDotSafeName(target);
        String endTag = DotConstants.END_LINE;
        IOUtils.write((String)startTag, (OutputStream)os);
        if (StringUtils.isNotBlank((CharSequence)label)) {
            this.writeOptions(os, {"label", label}, {"fontsize", this.fontSize});
        }
        IOUtils.write((String)endTag, (OutputStream)os);
    }

    private void writeGraphNode(String id, String label, OutputStream os) throws IOException {
        String tag = " \t" + this.getDotSafeName(id) + "[label = \"" + label + "\", fontsize = \"" + this.fontSize + "\"]" + DotConstants.END_LINE;
        IOUtils.write((String)tag, (OutputStream)os);
    }

    private void writeGraphNodes(OutputStream os) throws IOException {
        this.graph.vertices(new Object[0]).forEachRemaining(vertex -> {
            String id = vertex.id().toString();
            String label = (String)vertex.property(this.vertexLabelProperty).value();
            if (StringUtils.isBlank((CharSequence)label)) {
                label = vertex.toString();
            }
            try {
                this.writeGraphNode(id, label, os);
            }
            catch (IOException e) {
                throw new WindupException((Throwable)e);
            }
        });
    }

    private void writeOptions(OutputStream os, String[] ... options) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String[] option : options) {
            String key = option[0];
            String value = option[1];
            map.put(key, value);
        }
        this.writeOptions(map, os);
    }

    private void writeOptions(Map<String, String> options, OutputStream os) throws IOException {
        if (options == null || options.isEmpty()) {
            return;
        }
        IOUtils.write((String)"[", (OutputStream)os);
        StringBuilder builder = new StringBuilder();
        for (String key : options.keySet()) {
            builder.append(key + "=\"" + options.get(key) + "\", ");
        }
        String tag = builder.toString().trim();
        tag = StringUtils.removeEnd((String)tag, (String)",");
        IOUtils.write((String)tag, (OutputStream)os);
        IOUtils.write((String)"]", (OutputStream)os);
    }

    private String getDotSafeName(String inName) {
        Object name = null;
        name = StringUtils.isAlphanumeric((CharSequence)inName) ? inName : "\"" + inName + "\"";
        return name;
    }
}

