/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.renderer;

import java.io.IOException;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.janusgraph.core.JanusGraph;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.reporting.renderer.AbstractGraphRenderer;
import org.jboss.windup.reporting.renderer.dot.VizJSHtmlWriter;
import org.jboss.windup.reporting.renderer.gexf.SigmaJSHtmlWriter;
import org.jboss.windup.reporting.renderer.graphlib.DagreD3JSHtmlWriter;
import org.jboss.windup.util.Logging;

public class GraphExporter
extends AbstractGraphRenderer {
    private static final Logger LOG = Logging.get(GraphExporter.class);

    public void renderGraph(GraphContext context) {
        JanusGraph graph = context.getGraph();
        Path vizJSOutPath = this.createOutputFolder(context, "visjs");
        Path sigmaOutPath = this.createOutputFolder(context, "sigma");
        Path dagreD3OutPath = this.createOutputFolder(context, "dagred3");
        this.renderVizjs((Graph)graph, vizJSOutPath, "label", "id");
        this.renderSigma((Graph)graph, sigmaOutPath, "label", "id");
        this.renderDagreD3((Graph)graph, dagreD3OutPath, "label", "id");
    }

    public void renderVizjs(Graph graph, Path output, String vertexLabelProperty, String edgeLabel) {
        LOG.fine("Writing Vizjs graph to: " + output.toAbsolutePath());
        try {
            new VizJSHtmlWriter(graph, vertexLabelProperty, edgeLabel).writeGraph(output);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Failed to write graph visualization due to: " + e.getMessage(), e);
        }
    }

    public void renderSigma(Graph graph, Path output, String vertexLabelProperty, String edgeLabel) {
        LOG.fine("Writing Sigmajs graph to: " + output.toAbsolutePath());
        try {
            new SigmaJSHtmlWriter(graph, vertexLabelProperty, edgeLabel).writeGraph(output);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Failed to write graph visualization due to: " + e.getMessage(), e);
        }
    }

    public void renderDagreD3(Graph graph, Path output, String vertexLabelProperty, String edgeLabel) {
        LOG.fine("Writing DagreD3 graph to: " + output.toAbsolutePath());
        try {
            new DagreD3JSHtmlWriter(graph, vertexLabelProperty, edgeLabel).writeGraph(output);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Failed to write graph visualization due to: " + e.getMessage(), e);
        }
    }
}

