/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import freemarker.template.DefaultMapAdapter;
import freemarker.template.TemplateModelException;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.util.ExecutionStatistics;

public class MapToJsonMethod
implements WindupFreeMarkerMethod {
    public static final Logger LOG = Logger.getLogger(MapToJsonMethod.class.getName());
    private static final String NAME = "mapToJson";
    private GraphContext graphContext;

    public void setContext(GraphRewrite event) {
        this.graphContext = event.getGraphContext();
    }

    public String getMethodName() {
        return NAME;
    }

    public String getDescription() {
        return "Returns a JSON object representing the given map, having the keys as property names and values as property values.";
    }

    public Object exec(List arguments) throws TemplateModelException {
        ExecutionStatistics.get().begin(NAME);
        if (arguments.size() == 0) {
            throw new TemplateModelException("Freemarker function mapToJsonexpects a Map<String, String> as a parameter.");
        }
        Object arg0 = arguments.get(0);
        if (null == arg0) {
            return null;
        }
        if (!(arg0 instanceof DefaultMapAdapter)) {
            LOG.warning("Expected a Freemarker's DefaultMapAdapter, was: " + arg0.getClass());
            return null;
        }
        DefaultMapAdapter mapModel = (DefaultMapAdapter)arg0;
        Map map = (Map)mapModel.getWrappedObject();
        ObjectMapper mapper = new ObjectMapper();
        try {
            String json;
            String string = json = mapper.writeValueAsString((Object)map);
            return string;
        }
        catch (JsonProcessingException e) {
            throw new TemplateModelException("Couldn't convert given map to a JSON.");
        }
        finally {
            ExecutionStatistics.get().end(NAME);
        }
    }
}

