/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.util.ssa.InstructionByIIndexWrapper;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class InstructionByIIndexMap<Instruction extends SSAInstruction, T>
implements Map<Instruction, T> {
    private final Map<InstructionByIIndexWrapper<Instruction>, T> map;

    public InstructionByIIndexMap(Map<InstructionByIIndexWrapper<Instruction>, T> map) {
        this.map = map;
    }

    public InstructionByIIndexMap() {
        this.map = new LinkedHashMap<InstructionByIIndexWrapper<Instruction>, T>();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        SSAInstruction instruction;
        if (key instanceof SSAInstruction && (instruction = (SSAInstruction)key).iIndex() >= 0) {
            return this.map.containsKey(new InstructionByIIndexWrapper<SSAInstruction>(instruction));
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public T get(Object key) {
        SSAInstruction instruction;
        if (key instanceof SSAInstruction && (instruction = (SSAInstruction)key).iIndex() >= 0) {
            return this.map.get(new InstructionByIIndexWrapper<SSAInstruction>(instruction));
        }
        return null;
    }

    @Override
    public T put(Instruction key, T value) {
        return this.map.put(new InstructionByIIndexWrapper<Instruction>(key), value);
    }

    @Override
    public T remove(Object key) {
        SSAInstruction instruction;
        if (key instanceof SSAInstruction && (instruction = (SSAInstruction)key).iIndex() >= 0) {
            return this.map.remove(new InstructionByIIndexWrapper<SSAInstruction>(instruction));
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Instruction, ? extends T> m) {
        for (Map.Entry<Instruction, T> entry : m.entrySet()) {
            this.put((Instruction)((SSAInstruction)entry.getKey()), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<Instruction> keySet() {
        LinkedHashSet<Instruction> result = new LinkedHashSet<Instruction>();
        for (InstructionByIIndexWrapper<Instruction> wrapper : this.map.keySet()) {
            result.add(wrapper.getInstruction());
        }
        return result;
    }

    @Override
    public Collection<T> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<Instruction, T>> entrySet() {
        LinkedHashSet<Map.Entry<Instruction, T>> result = new LinkedHashSet<Map.Entry<Instruction, T>>();
        for (Map.Entry<InstructionByIIndexWrapper<Instruction>, T> entry : this.map.entrySet()) {
            result.add(new AbstractMap.SimpleImmutableEntry<Instruction, T>(entry.getKey().getInstruction(), entry.getValue()));
        }
        return result;
    }
}

