/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa.analysis;

import com.ibm.wala.fixedpoint.impl.DefaultFixedPointSolver;
import com.ibm.wala.fixpoint.BooleanVariable;
import com.ibm.wala.fixpoint.IVariable;
import com.ibm.wala.fixpoint.UnaryOperator;
import com.ibm.wala.fixpoint.UnaryOr;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.CancelRuntimeException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class DeadAssignmentElimination {
    private static final boolean DEBUG = false;

    public static void perform(IR ir) {
        if (ir == null) {
            throw new IllegalArgumentException("ir is null");
        }
        DefUse DU = new DefUse(ir);
        DeadValueSystem system = new DeadValueSystem(ir, DU);
        try {
            system.solve(null);
        }
        catch (CancelException e) {
            throw new CancelRuntimeException((Exception)((Object)e));
        }
        DeadAssignmentElimination.doTransformation(ir, system);
    }

    private static void doTransformation(IR ir, DeadValueSystem solution) {
        SSACFG cfg = ir.getControlFlowGraph();
        Iterator iterator = cfg.iterator();
        while (iterator.hasNext()) {
            ISSABasicBlock issaBasicBlock = (ISSABasicBlock)iterator.next();
            SSACFG.BasicBlock b = (SSACFG.BasicBlock)issaBasicBlock;
            if (!b.hasPhi()) continue;
            HashSet toRemove = HashSetFactory.make((int)5);
            for (SSAPhiInstruction phi : Iterator2Iterable.make(b.iteratePhis())) {
                int def;
                if (phi == null || !solution.isDead(def = phi.getDef())) continue;
                toRemove.add(phi);
            }
            b.removePhis(toRemove);
        }
    }

    private static class DeadValueSystem
    extends DefaultFixedPointSolver<BooleanVariable> {
        private final Map<Integer, BooleanVariable> vars = HashMapFactory.make();
        private final HashSet<Integer> trivialDead = HashSetFactory.make();

        DeadValueSystem(IR ir, DefUse DU) {
            for (SSAInstruction inst : Iterator2Iterable.make(ir.iteratePhis())) {
                SSAPhiInstruction phi = (SSAPhiInstruction)inst;
                if (phi == null) continue;
                int def = phi.getDef();
                if (DU.isUnused(def)) {
                    this.trivialDead.add(def);
                    continue;
                }
                boolean maybeDead = true;
                for (SSAInstruction u : Iterator2Iterable.make(DU.getUses(def))) {
                    if (u instanceof SSAPhiInstruction) continue;
                    maybeDead = false;
                    break;
                }
                if (!maybeDead) continue;
                BooleanVariable B = new BooleanVariable(false);
                this.vars.put(def, B);
            }
            for (Map.Entry<Integer, BooleanVariable> E : this.vars.entrySet()) {
                Integer def = E.getKey();
                BooleanVariable B = E.getValue();
                for (SSAInstruction use : Iterator2Iterable.make(DU.getUses(def))) {
                    SSAInstruction u;
                    u = (SSAPhiInstruction)use;
                    Integer ud = ((SSAPhiInstruction)u).getDef();
                    if (this.trivialDead.contains(ud)) continue;
                    if (!this.vars.containsKey(ud)) {
                        B.set(true);
                        continue;
                    }
                    BooleanVariable U = this.vars.get(ud);
                    this.newStatement((IVariable)B, (UnaryOperator)UnaryOr.instance(), (IVariable)U, true, false);
                }
            }
        }

        protected void initializeVariables() {
        }

        protected void initializeWorkList() {
            this.addAllStatementsToWorkList();
        }

        private boolean isDead(int value) {
            Integer V = value;
            if (this.trivialDead.contains(V)) {
                return true;
            }
            BooleanVariable B = this.vars.get(V);
            if (B == null) {
                return false;
            }
            return !B.getValue();
        }

        protected BooleanVariable[] makeStmtRHS(int size) {
            return new BooleanVariable[size];
        }
    }
}

