/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.reflection;

import com.ibm.wala.analysis.reflection.JavaTypeContext;
import com.ibm.wala.analysis.typeInference.PointType;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.propagation.ConstantKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.intset.EmptyIntSet;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.strings.StringStuff;

class ClassFactoryContextSelector
implements ContextSelector {
    public static final Atom forNameAtom = Atom.findOrCreateUnicodeAtom("forName");
    private static final Descriptor forNameDescriptor = Descriptor.findOrCreateUTF8("(Ljava/lang/String;)Ljava/lang/Class;");
    public static final MethodReference FOR_NAME_REF = MethodReference.findOrCreate(TypeReference.JavaLangClass, forNameAtom, forNameDescriptor);
    public static final Atom loadClassAtom = Atom.findOrCreateUnicodeAtom("loadClass");
    private static final Descriptor loadClassDescriptor = Descriptor.findOrCreateUTF8("(Ljava/lang/String;)Ljava/lang/Class;");
    private static final TypeReference CLASSLOADER = TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/ClassLoader");
    public static final MethodReference LOAD_CLASS_REF = MethodReference.findOrCreate(CLASSLOADER, loadClassAtom, loadClassDescriptor);
    private static final IntSet thisParameter = IntSetUtil.make((int[])new int[]{0});
    private static final IntSet firstParameter = IntSetUtil.make((int[])new int[]{0, 1});

    public static boolean isClassFactory(MethodReference m) {
        if (m.equals(FOR_NAME_REF)) {
            return true;
        }
        return m.equals(LOAD_CLASS_REF);
    }

    public int getUseOfStringParameter(SSAAbstractInvokeInstruction call) {
        if (call.isStatic()) {
            return call.getUse(0);
        }
        return call.getUse(1);
    }

    @Override
    public Context getCalleeTarget(CGNode caller, CallSiteReference site, IMethod callee, InstanceKey[] receiver) {
        if (ClassFactoryContextSelector.isClassFactory(callee.getReference())) {
            ConstantKey ik;
            int nameVn;
            IR ir = caller.getIR();
            SymbolTable symbolTable = ir.getSymbolTable();
            SSAAbstractInvokeInstruction[] invokeInstructions = caller.getIR().getCalls(site);
            if (invokeInstructions.length != 1) {
                return null;
            }
            int use = this.getUseOfStringParameter(invokeInstructions[0]);
            if (symbolTable.isStringConstant(use)) {
                String className = StringStuff.deployment2CanonicalTypeString(symbolTable.getStringValue(use));
                TypeReference t = TypeReference.findOrCreate(caller.getMethod().getDeclaringClass().getClassLoader().getReference(), className);
                IClass klass = caller.getClassHierarchy().lookupClass(t);
                if (klass != null) {
                    return new JavaTypeContext(new PointType(klass));
                }
            }
            int n = nameVn = callee.isStatic() ? 0 : 1;
            if (receiver != null && receiver.length > nameVn && receiver[nameVn] instanceof ConstantKey && (ik = (ConstantKey)receiver[nameVn]).getConcreteType().getReference().equals(TypeReference.JavaLangString)) {
                String className = StringStuff.deployment2CanonicalTypeString(ik.getValue().toString());
                for (IClassLoader cl : caller.getClassHierarchy().getLoaders()) {
                    TypeReference t = TypeReference.findOrCreate(cl.getReference(), className);
                    IClass klass = caller.getClassHierarchy().lookupClass(t);
                    if (klass == null) continue;
                    return new JavaTypeContext(new PointType(klass));
                }
            }
        }
        return null;
    }

    @Override
    public IntSet getRelevantParameters(CGNode caller, CallSiteReference site) {
        IMethod resolved = caller.getMethod().getClassHierarchy().resolveMethod(site.getDeclaredTarget());
        if (ClassFactoryContextSelector.isClassFactory(resolved != null ? resolved.getReference() : site.getDeclaredTarget())) {
            SSAAbstractInvokeInstruction[] invokeInstructions = caller.getIR().getCalls(site);
            if (invokeInstructions.length >= 1) {
                if (invokeInstructions[0].isStatic()) {
                    return thisParameter;
                }
                return firstParameter;
            }
            return EmptyIntSet.instance;
        }
        return EmptyIntSet.instance;
    }
}

