/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.java.translator.jdt;

import com.ibm.wala.cast.java.translator.jdt.JDT2CAstUtils;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.strings.Atom;
import java.util.Map;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;

public class JDTIdentityMapper {
    private final Map<String, TypeReference> fTypeMap = HashMapFactory.make();
    private final Map<String, FieldReference> fFieldMap = HashMapFactory.make();
    private final Map<String, MethodReference> fMethodMap = HashMapFactory.make();
    private final ClassLoaderReference fClassLoaderRef;
    private final AST fAst;

    public JDTIdentityMapper(ClassLoaderReference clr, AST ast) {
        this.fClassLoaderRef = clr;
        this.fAst = ast;
    }

    public TypeReference getTypeRef(ITypeBinding type) {
        if (!this.fTypeMap.containsKey((type = JDT2CAstUtils.getErasedType(type, this.fAst)).getKey())) {
            TypeName typeName = TypeName.string2TypeName((String)this.typeToTypeID(type));
            TypeReference ref = TypeReference.findOrCreate((ClassLoaderReference)this.fClassLoaderRef, (TypeName)typeName);
            this.fTypeMap.put(type.getKey(), ref);
            return ref;
        }
        return this.fTypeMap.get(type.getKey());
    }

    public String typeToTypeID(ITypeBinding type) {
        if (type.isPrimitive()) {
            return type.getBinaryName();
        }
        if (type.isArray()) {
            return type.getBinaryName().replace('.', '/').replace(";", "");
        }
        if (type.isLocal() || type.isAnonymous()) {
            return this.anonLocalTypeToTypeID(type);
        }
        if (type.isClass() || type.isEnum() || type.isInterface()) {
            return 'L' + type.getBinaryName().replace('.', '/');
        }
        if (type.isTypeVariable()) {
            return this.typeToTypeID(JDT2CAstUtils.getTypesVariablesBase(type, this.fAst));
        }
        Assertions.UNREACHABLE((String)("typeToTypeID() encountered the type " + type + " that is neither primitive, array, nor class!"));
        return null;
    }

    public String anonLocalTypeToTypeID(ITypeBinding type) {
        String outerTypeID = this.typeToTypeID(type.getDeclaringClass());
        IMethodBinding metBinding = type.getDeclaringMethod();
        String metSelectorName = metBinding == null ? "<init>" : this.getMethodRef(metBinding).getSelector().toString();
        String shortName = type.isAnonymous() ? JDT2CAstUtils.anonTypeName(type) : type.getName();
        return outerTypeID + '/' + metSelectorName + '/' + shortName;
    }

    public FieldReference getFieldRef(IVariableBinding field) {
        if (!this.fFieldMap.containsKey(field.getKey())) {
            ITypeBinding targetType = field.getDeclaringClass();
            TypeReference targetTypeRef = TypeReference.findOrCreate((ClassLoaderReference)this.fClassLoaderRef, (String)this.typeToTypeID(targetType));
            ITypeBinding fieldType = field.getType();
            TypeReference fieldTypeRef = TypeReference.findOrCreate((ClassLoaderReference)this.fClassLoaderRef, (String)this.typeToTypeID(fieldType));
            Atom fieldName = Atom.findOrCreateUnicodeAtom((String)field.getName());
            FieldReference ref = FieldReference.findOrCreate((TypeReference)targetTypeRef, (Atom)fieldName, (TypeReference)fieldTypeRef);
            this.fFieldMap.put(field.getKey(), ref);
            return ref;
        }
        return this.fFieldMap.get(field.getKey());
    }

    public MethodReference fakeMethodRefNoArgs(String key, String typeID, String metName, String returnTypeID) {
        if (!this.fMethodMap.containsKey(key)) {
            TypeName ownerType = TypeName.string2TypeName((String)typeID);
            TypeReference ownerTypeRef = TypeReference.findOrCreate((ClassLoaderReference)this.fClassLoaderRef, (TypeName)ownerType);
            Atom name = Atom.findOrCreateUnicodeAtom((String)metName);
            TypeName[] argTypeNames = null;
            TypeName retTypeName = TypeName.string2TypeName((String)returnTypeID);
            Descriptor desc = Descriptor.findOrCreate(argTypeNames, (TypeName)retTypeName);
            Selector selector = new Selector(name, desc);
            MethodReference ref = MethodReference.findOrCreate((TypeReference)ownerTypeRef, (Selector)selector);
            this.fMethodMap.put(key, ref);
            return ref;
        }
        return this.fMethodMap.get(key);
    }

    public MethodReference getMethodRef(IMethodBinding met) {
        if (!this.fMethodMap.containsKey(met.getKey())) {
            TypeName ownerType = TypeName.string2TypeName((String)this.typeToTypeID(met.getDeclaringClass()));
            TypeReference ownerTypeRef = TypeReference.findOrCreate((ClassLoaderReference)this.fClassLoaderRef, (TypeName)ownerType);
            MethodReference ref = MethodReference.findOrCreate((TypeReference)ownerTypeRef, (Selector)this.selectorForMethod(met));
            this.fMethodMap.put(met.getKey(), ref);
            return ref;
        }
        return this.fMethodMap.get(met.getKey());
    }

    private Selector selectorForMethod(IMethodBinding met) {
        Atom name = met.isConstructor() ? MethodReference.initAtom : Atom.findOrCreateUnicodeAtom((String)met.getName());
        TypeName[] argTypeNames = null;
        ITypeBinding[] formalTypes = met.getParameterTypes();
        int length = formalTypes.length;
        if (met.isConstructor() && met.getDeclaringClass().isEnum()) {
            length += 2;
        }
        if (length > 0) {
            argTypeNames = new TypeName[length];
            int i = 0;
            if (met.isConstructor() && met.getDeclaringClass().isEnum()) {
                argTypeNames[0] = TypeName.string2TypeName((String)this.typeToTypeID(this.fAst.resolveWellKnownType("java.lang.String")));
                argTypeNames[1] = TypeName.string2TypeName((String)this.typeToTypeID(this.fAst.resolveWellKnownType("int")));
                i = 2;
            }
            for (ITypeBinding argType : formalTypes) {
                argTypeNames[i++] = TypeName.string2TypeName((String)this.typeToTypeID(argType));
            }
        }
        TypeName retTypeName = TypeName.string2TypeName((String)this.typeToTypeID(met.getReturnType()));
        Descriptor desc = Descriptor.findOrCreate((TypeName[])argTypeNames, (TypeName)retTypeName);
        return new Selector(name, desc);
    }
}

