/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.java.ecj.util;

import com.ibm.wala.cast.ir.ssa.AstIRFactory;
import com.ibm.wala.cast.java.client.impl.ZeroOneContainerCFABuilderFactory;
import com.ibm.wala.cast.java.ipa.callgraph.JavaSourceAnalysisScope;
import com.ibm.wala.cast.java.translator.jdt.ecj.ECJClassLoaderFactory;
import com.ibm.wala.classLoader.ClassLoaderFactory;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.SourceDirectoryTreeModule;
import com.ibm.wala.classLoader.SourceFileModule;
import com.ibm.wala.ipa.callgraph.AnalysisCacheImpl;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphBuilder;
import com.ibm.wala.ipa.callgraph.CallGraphBuilderCancelException;
import com.ibm.wala.ipa.callgraph.CallGraphStats;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.ClassHierarchyFactory;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.properties.WalaProperties;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.io.CommandLine;
import com.ibm.wala.util.warnings.Warnings;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.jar.JarFile;

public class SourceDirCallGraph {
    public static void main(String[] args) throws ClassHierarchyException, IllegalArgumentException, CallGraphBuilderCancelException, IOException {
        new SourceDirCallGraph().doit(args, (cg, builder, time) -> {
            System.out.println("done");
            System.out.println("took " + time + "ms");
            System.out.println(CallGraphStats.getStats((CallGraph)cg));
        });
    }

    protected ClassLoaderFactory getLoaderFactory(AnalysisScope scope) {
        return new ECJClassLoaderFactory(scope.getExclusions());
    }

    public void doit(String[] args, Processor processor) throws ClassHierarchyException, IllegalArgumentException, CallGraphBuilderCancelException, IOException {
        String[] stdlibs;
        long start = System.currentTimeMillis();
        Properties p = CommandLine.parse((String[])args);
        String sourceDir = p.getProperty("sourceDir");
        String mainClass = p.getProperty("mainClass");
        JavaSourceAnalysisScope scope = new JavaSourceAnalysisScope();
        for (String stdlib : stdlibs = WalaProperties.getJ2SEJarFiles()) {
            scope.addToScope(ClassLoaderReference.Primordial, new JarFile(stdlib));
        }
        File root = new File(sourceDir);
        if (root.isDirectory()) {
            scope.addToScope(JavaSourceAnalysisScope.SOURCE, (Module)new SourceDirectoryTreeModule(root));
        } else {
            String srcFileName = sourceDir.substring(sourceDir.lastIndexOf(File.separator) + 1);
            assert (root.exists()) : "couldn't find " + sourceDir;
            scope.addToScope(JavaSourceAnalysisScope.SOURCE, (Module)new SourceFileModule(root, srcFileName, null));
        }
        ClassHierarchy cha = ClassHierarchyFactory.make((AnalysisScope)scope, (ClassLoaderFactory)this.getLoaderFactory((AnalysisScope)scope));
        System.out.println(cha.getNumberOfClasses() + " classes");
        System.out.println(Warnings.asString());
        Warnings.clear();
        AnalysisOptions options = new AnalysisOptions();
        Iterable<Entrypoint> entrypoints = this.getEntrypoints(mainClass, (IClassHierarchy)cha);
        options.setEntrypoints(entrypoints);
        options.getSSAOptions().setDefaultValues(new SSAOptions.DefaultValues(){

            public int getDefaultValue(SymbolTable symtab, int valueNumber) {
                return symtab.getDefaultValue(valueNumber);
            }
        });
        options.setReflectionOptions(AnalysisOptions.ReflectionOptions.NONE);
        AnalysisCacheImpl cache = new AnalysisCacheImpl(AstIRFactory.makeDefaultFactory(), options.getSSAOptions());
        CallGraphBuilder builder = new ZeroOneContainerCFABuilderFactory().make(options, (IAnalysisCacheView)cache, (IClassHierarchy)cha, (AnalysisScope)scope);
        System.out.println("building call graph...");
        CallGraph cg = builder.makeCallGraph(options, null);
        long end = System.currentTimeMillis();
        processor.process(cg, builder, end - start);
    }

    protected Iterable<Entrypoint> getEntrypoints(String mainClass, IClassHierarchy cha) {
        Iterable entrypoints = Util.makeMainEntrypoints((ClassLoaderReference)JavaSourceAnalysisScope.SOURCE, (IClassHierarchy)cha, (String[])new String[]{mainClass});
        return entrypoints;
    }

    @FunctionalInterface
    public static interface Processor {
        public void process(CallGraph var1, CallGraphBuilder<?> var2, long var3);
    }
}

