/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.service;

import com.syncleus.ferma.FramedGraph;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.janusgraph.core.attribute.Text;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.frames.FramedVertexIterable;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.FileService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.javaee.model.association.VendorSpecificationExtensionModel;

public class VendorSpecificationExtensionService
extends GraphService<VendorSpecificationExtensionModel> {
    private static final Logger LOG = Logger.getLogger(VendorSpecificationExtensionService.class.getName());
    protected final FileService fileService = new FileService(this.getGraphContext());

    public VendorSpecificationExtensionService(GraphContext context) {
        super(context, VendorSpecificationExtensionModel.class);
    }

    public Iterable<VendorSpecificationExtensionModel> getVendorSpecificationExtensions(FileModel model) {
        GraphTraversal pipeline = new GraphTraversalSource((Graph)this.getGraphContext().getGraph()).V(new Object[]{model.getElement()});
        pipeline.out(new String[]{"vendorSpecification"});
        pipeline.has("w:winduptype", Text.textContains((Object)"VendorSpecificationExtensionModel"));
        return new FramedVertexIterable((FramedGraph)this.getGraphContext().getFramed(), (Iterable)pipeline.toList(), VendorSpecificationExtensionModel.class);
    }

    public VendorSpecificationExtensionModel associateAsVendorExtension(FileModel model, String localFileName) {
        Object pathToDescriptor = model.getFilePath();
        pathToDescriptor = StringUtils.removeEnd((String)pathToDescriptor, (String)model.getFileName());
        pathToDescriptor = (String)pathToDescriptor + localFileName;
        FileModel specificationFile = (FileModel)this.fileService.getUniqueByProperty("filePath", pathToDescriptor);
        VendorSpecificationExtensionModel extension = (VendorSpecificationExtensionModel)this.addTypeToModel((WindupVertexFrame)model);
        if (specificationFile == null) {
            LOG.warning("File not found: " + (String)pathToDescriptor);
        } else {
            extension.setSpecificationFile(specificationFile);
        }
        return extension;
    }
}

