/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.service;

import java.util.logging.Logger;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.attribute.Text;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.javaee.model.RMIServiceModel;
import org.jboss.windup.util.Logging;

public class RMIServiceModelService
extends GraphService<RMIServiceModel> {
    private static final Logger LOG = Logging.get(RMIServiceModelService.class);

    public RMIServiceModelService(GraphContext context) {
        super(context, RMIServiceModel.class);
    }

    public RMIServiceModel getOrCreate(ProjectModel application, JavaClassModel rmiInterface) {
        LOG.info("RMI Interface: " + rmiInterface.getQualifiedName());
        RMIServiceModel rmiServiceModel = this.findByInterface(rmiInterface);
        if (rmiServiceModel == null) {
            rmiServiceModel = (RMIServiceModel)this.create();
            rmiServiceModel.addApplication(application);
            rmiServiceModel.setInterface(rmiInterface);
            for (JavaClassModel implModel : rmiInterface.getImplementedBy()) {
                LOG.info(" -- Implementations: " + implModel.getQualifiedName());
                rmiServiceModel.setImplementationClass(implModel);
            }
        } else if (!rmiServiceModel.isAssociatedWithApplication(application)) {
            rmiServiceModel.addApplication(application);
        }
        return rmiServiceModel;
    }

    private RMIServiceModel findByInterface(JavaClassModel rmiInterface) {
        GraphTraversal pipeline = new GraphTraversalSource((Graph)this.getGraphContext().getGraph()).V(new Object[]{rmiInterface.getElement()});
        pipeline.in(new String[]{"rmiInterface"});
        pipeline.has("w:winduptype", Text.textContains((Object)"RMIServiceModel"));
        if (pipeline.hasNext()) {
            return (RMIServiceModel)this.frame((Vertex)pipeline.next());
        }
        return null;
    }
}

