/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.service;

import java.util.logging.Logger;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.javaee.model.EnvironmentReferenceModel;
import org.jboss.windup.rules.apps.javaee.model.EnvironmentReferenceTagType;
import org.jboss.windup.rules.apps.javaee.model.JNDIResourceModel;
import org.jboss.windup.rules.apps.javaee.service.JNDIResourceService;

public class EnvironmentReferenceService
extends GraphService<EnvironmentReferenceModel> {
    private static final Logger LOG = Logger.getLogger(EnvironmentReferenceService.class.getName());
    protected JNDIResourceService jndiResourceService;

    public EnvironmentReferenceService(GraphContext context) {
        super(context, EnvironmentReferenceModel.class);
        this.jndiResourceService = new JNDIResourceService(context);
    }

    public EnvironmentReferenceModel findEnvironmentReference(String name, EnvironmentReferenceTagType type) {
        GraphTraversal query = this.findAllQuery().getRawTraversal().has("name", (Object)name).has("referenceTagType", (Object)type);
        return (EnvironmentReferenceModel)this.getUnique((Traversal)query);
    }

    public void associateEnvironmentToJndi(JNDIResourceModel resource, EnvironmentReferenceModel ref) {
        LOG.info("Associating JNDI: " + resource + " to Environmental Ref: " + ref.getName() + ", " + ref.getReferenceId() + ", " + ref.getReferenceType());
        if (ref.getJndiReference() == null) {
            ref.setJndiReference(resource);
        }
        this.jndiResourceService.associateTypeJndiResource(resource, ref.getReferenceType());
    }
}

