/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.attribute.Text;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.projecttraversal.ProjectTraversalCache;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.QueryGremlinCriterion;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.service.JavaClassService;
import org.jboss.windup.rules.apps.javaee.model.HibernateEntityModel;
import org.jboss.windup.rules.apps.javaee.model.HibernateMappingFileModel;
import org.jboss.windup.rules.apps.javaee.service.HibernateEntityService;
import org.jboss.windup.rules.apps.javaee.service.HibernateMappingFileService;
import org.jboss.windup.rules.apps.xml.model.DoctypeMetaModel;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.service.XmlFileService;
import org.jboss.windup.util.xml.XmlUtil;
import org.joox.JOOX;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@RuleMetadata(phase=InitialAnalysisPhase.class, perform="Discover hibernate.hbm.xml files")
public class DiscoverHibernateMappingRuleProvider
extends IteratingRuleProvider<DoctypeMetaModel> {
    private static final Logger LOG = Logger.getLogger(DiscoverHibernateMappingRuleProvider.class.getName());
    private static final String TECH_TAG = "Hibernate Mapping";
    private static final TechnologyTagLevel TECH_TAG_LEVEL = TechnologyTagLevel.IMPORTANT;
    private static final String REGEX_HIBERNATE = "(?i).*hibernate.mapping.*";

    public ConditionBuilder when() {
        QueryGremlinCriterion doctypeSearchCriterion = new QueryGremlinCriterion(){

            public void query(GraphRewrite event, GraphTraversal<?, Vertex> pipeline) {
                pipeline.has("DoctypeMetaModel-publicId", Text.textRegex((Object)DiscoverHibernateMappingRuleProvider.REGEX_HIBERNATE));
                GraphTraversal systemIDQuery = event.getGraphContext().getQuery(DoctypeMetaModel.class).getRawTraversal().has("DoctypeMetaModel-systemId", Text.textRegex((Object)DiscoverHibernateMappingRuleProvider.REGEX_HIBERNATE));
                GraphTraversal systemIdPipeline = new GraphTraversalSource((Graph)event.getGraphContext().getGraph()).V(new Object[]{systemIDQuery.toList()});
                pipeline.union(new Traversal[]{systemIdPipeline});
                pipeline.dedup(new String[0]);
            }
        };
        return Query.fromType(DoctypeMetaModel.class).piped(doctypeSearchCriterion);
    }

    public void perform(GraphRewrite event, EvaluationContext context, DoctypeMetaModel payload) {
        JavaClassService javaClassService = new JavaClassService(event.getGraphContext());
        HibernateMappingFileService hibernateMappingFileService = new HibernateMappingFileService(event.getGraphContext());
        HibernateEntityService hibernateEntityService = new HibernateEntityService(event.getGraphContext());
        XmlFileService xmlFileService = new XmlFileService(event.getGraphContext());
        TechnologyTagService technologyTagService = new TechnologyTagService(event.getGraphContext());
        String publicId = payload.getPublicId();
        String systemId = payload.getSystemId();
        String versionInformation = this.extractVersion(publicId, systemId);
        for (XmlFileModel xml : payload.getXmlResources()) {
            HibernateMappingFileModel hibernateMapping = (HibernateMappingFileModel)hibernateMappingFileService.addTypeToModel((WindupVertexFrame)xml);
            Document doc = xmlFileService.loadDocumentQuiet(event, context, (XmlFileModel)hibernateMapping);
            if (!XmlUtil.xpathExists((Node)doc, (String)"/hibernate-mapping", null)) {
                LOG.log(Level.INFO, "Docment does not contain Hibernate Mapping.");
                continue;
            }
            String clzPkg = JOOX.$((Document)doc).xpath("/hibernate-mapping").attr("package");
            Object clzName = JOOX.$((Document)doc).xpath("/hibernate-mapping/class").attr("name");
            String tableName = JOOX.$((Document)doc).xpath("/hibernate-mapping/class").attr("table");
            String schemaName = JOOX.$((Document)doc).xpath("/hibernate-mapping/class").attr("schema");
            String catalogName = JOOX.$((Document)doc).xpath("/hibernate-mapping/class").attr("catalog");
            if (StringUtils.isBlank((CharSequence)clzName)) {
                LOG.log(Level.FINE, "Docment does not contain class name. Skipping.");
                continue;
            }
            technologyTagService.addTagToFileModel((FileModel)xml, TECH_TAG, TECH_TAG_LEVEL);
            if (StringUtils.isNotBlank((CharSequence)clzPkg) && !StringUtils.startsWith((CharSequence)clzName, (CharSequence)clzPkg)) {
                clzName = clzPkg + "." + (String)clzName;
            }
            JavaClassModel clz = javaClassService.getOrCreatePhantom((String)clzName);
            HibernateEntityModel hibernateEntity = (HibernateEntityModel)hibernateEntityService.create();
            hibernateEntity.setSpecificationVersion(versionInformation);
            hibernateEntity.setApplications(ProjectTraversalCache.getApplicationsForProject((GraphContext)event.getGraphContext(), (ProjectModel)xml.getProjectModel()));
            hibernateEntity.setJavaClass(clz);
            hibernateEntity.setTableName(tableName);
            hibernateEntity.setSchemaName(schemaName);
            hibernateEntity.setCatalogName(catalogName);
            hibernateMapping.addHibernateEntity(hibernateEntity);
            if (!StringUtils.isNotBlank((CharSequence)versionInformation)) continue;
            hibernateEntity.setSpecificationVersion(versionInformation);
            hibernateMapping.setSpecificationVersion(versionInformation);
        }
    }

    private String extractVersion(String publicId, String systemId) {
        Matcher matcher;
        Pattern pattern = Pattern.compile("[0-9][0-9a-zA-Z.-]+");
        if (StringUtils.isNotBlank((CharSequence)publicId) && (matcher = pattern.matcher(publicId)).find()) {
            return matcher.group();
        }
        if (StringUtils.isNotBlank((CharSequence)systemId) && (matcher = pattern.matcher(systemId)).find()) {
            String match = matcher.group();
            return StringUtils.removeEnd((String)match, (String)".dtd");
        }
        return null;
    }
}

