/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules;

import java.util.ArrayList;
import java.util.HashMap;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.ReportGenerationPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.model.ApplicationReportModel;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.model.WindupVertexListModel;
import org.jboss.windup.reporting.service.ApplicationReportService;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.rules.apps.javaee.model.EjbRemoteServiceModel;
import org.jboss.windup.rules.apps.javaee.model.JaxRSWebServiceModel;
import org.jboss.windup.rules.apps.javaee.model.JaxWSWebServiceModel;
import org.jboss.windup.rules.apps.javaee.model.RMIServiceModel;
import org.jboss.windup.rules.apps.javaee.model.RemoteServiceModel;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=ReportGenerationPhase.class, id="Create Remote Services Report")
public class CreateRemoteReportRuleProvider
extends AbstractRuleProvider {
    public static final String TEMPLATE_EJB_REPORT = "/reports/templates/remote.ftl";
    public static final String REPORT_DESCRIPTION = "This report displays all remote services references that were found within the application.";

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        return ConfigurationBuilder.begin().addRule().when((Condition)Query.fromType(RemoteServiceModel.class)).perform((Operation)new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext context) {
                WindupConfigurationModel configurationModel = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
                for (FileModel inputPath : configurationModel.getInputPaths()) {
                    ProjectModel projectModel = inputPath.getProjectModel();
                    CreateRemoteReportRuleProvider.this.createReport(event.getGraphContext(), projectModel);
                }
            }

            public String toString() {
                return "CreateRemoteServiceReport";
            }
        });
    }

    private void createReport(GraphContext context, ProjectModel projectModel) {
        GraphService remoteServices = new GraphService(context, RemoteServiceModel.class);
        ArrayList<JaxRSWebServiceModel> jaxRsList = new ArrayList<JaxRSWebServiceModel>();
        ArrayList<JaxWSWebServiceModel> jaxWsList = new ArrayList<JaxWSWebServiceModel>();
        ArrayList<EjbRemoteServiceModel> ejbRemoteList = new ArrayList<EjbRemoteServiceModel>();
        ArrayList<RMIServiceModel> rmiList = new ArrayList<RMIServiceModel>();
        for (RemoteServiceModel remoteServiceModel : remoteServices.findAll()) {
            if (!remoteServiceModel.isAssociatedWithApplication(projectModel)) continue;
            if (remoteServiceModel instanceof JaxRSWebServiceModel) {
                jaxRsList.add((JaxRSWebServiceModel)remoteServiceModel);
                continue;
            }
            if (remoteServiceModel instanceof JaxWSWebServiceModel) {
                jaxWsList.add((JaxWSWebServiceModel)remoteServiceModel);
                continue;
            }
            if (remoteServiceModel instanceof EjbRemoteServiceModel) {
                ejbRemoteList.add((EjbRemoteServiceModel)remoteServiceModel);
                continue;
            }
            if (!(remoteServiceModel instanceof RMIServiceModel)) continue;
            rmiList.add((RMIServiceModel)remoteServiceModel);
        }
        if (jaxRsList.isEmpty() && jaxWsList.isEmpty() && ejbRemoteList.isEmpty() && rmiList.isEmpty()) {
            return;
        }
        ApplicationReportService applicationReportService = new ApplicationReportService(context);
        ApplicationReportModel applicationReportModel = applicationReportService.create();
        applicationReportModel.setReportPriority(300);
        applicationReportModel.setDisplayInApplicationReportIndex(Boolean.valueOf(true));
        applicationReportModel.setReportName("Remote Services");
        applicationReportModel.setDescription(REPORT_DESCRIPTION);
        applicationReportModel.setReportIconClass("glyphicon service-nav-logo");
        applicationReportModel.setProjectModel(projectModel);
        applicationReportModel.setTemplatePath(TEMPLATE_EJB_REPORT);
        applicationReportModel.setTemplateType(TemplateType.FREEMARKER);
        GraphService listService = new GraphService(context, WindupVertexListModel.class);
        HashMap<String, WindupVertexListModel> data = new HashMap<String, WindupVertexListModel>(4);
        data.put("jaxRsServices", ((WindupVertexListModel)listService.create()).addAll(jaxRsList));
        data.put("jaxWsServices", ((WindupVertexListModel)listService.create()).addAll(jaxWsList));
        data.put("ejbRemoteServices", ((WindupVertexListModel)listService.create()).addAll(ejbRemoteList));
        data.put("rmiServices", ((WindupVertexListModel)listService.create()).addAll(rmiList));
        applicationReportModel.setRelatedResource(data);
        ReportService reportService = new ReportService(context);
        reportService.setUniqueFilename((ReportModel)applicationReportModel, "remotereport_" + projectModel.getName(), "html");
    }
}

