/*
 * Decompiled with CFR 0.152.
 */
package io.tackle.diva;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ibm.wala.analysis.reflection.ReflectionContextInterpreter;
import com.ibm.wala.cast.ipa.callgraph.AstContextInsensitiveSSAContextInterpreter;
import com.ibm.wala.cast.ir.ssa.AstIRFactory;
import com.ibm.wala.cast.java.client.impl.ZeroCFABuilderFactory;
import com.ibm.wala.cast.java.ipa.callgraph.AstJavaZeroXCFABuilder;
import com.ibm.wala.classLoader.BinaryDirectoryTreeModule;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.JarFileEntry;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.classLoader.ShrikeClass;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisCacheImpl;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphBuilder;
import com.ibm.wala.ipa.callgraph.ClassTargetSelector;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.callgraph.MethodTargetSelector;
import com.ibm.wala.ipa.callgraph.cha.CHACallGraph;
import com.ibm.wala.ipa.callgraph.impl.ClassHierarchyClassTargetSelector;
import com.ibm.wala.ipa.callgraph.impl.ClassHierarchyMethodTargetSelector;
import com.ibm.wala.ipa.callgraph.impl.DefaultContextSelector;
import com.ibm.wala.ipa.callgraph.impl.DefaultEntrypoint;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.impl.FakeRootMethod;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.cfa.DefaultSSAInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.cfa.DelegatingSSAContextInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.rta.BasicRTABuilder;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.ConstantPoolParser;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.AuxiliaryCache;
import com.ibm.wala.ssa.IAuxiliaryCache;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.IRFactory;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSACache;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.intset.BimodalMutableIntSet;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.ref.CacheReference;
import io.tackle.diva.Constraint;
import io.tackle.diva.Context;
import io.tackle.diva.Report;
import io.tackle.diva.Trace;
import io.tackle.diva.Util;
import io.tackle.diva.analysis.JDBCAnalysis;
import io.tackle.diva.analysis.JPAAnalysis;
import io.tackle.diva.analysis.SpringBootAnalysis;
import io.tackle.diva.irgen.DivaPhantomClass;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;

public class Framework {
    private static final Logger LOGGER = Logger.getLogger(Framework.class.getName());
    IClassHierarchy cha;
    CallGraph callgraph;
    public boolean usageAnalysis;
    public static HttpClient httpClient = HttpClientBuilder.create().build();
    public static final Pattern patternWar = Pattern.compile(".*\\.war");
    public static final Pattern patternJar = Pattern.compile(".*\\.jar");
    public static final Pattern patternClasses = Pattern.compile(".*/classes$");
    static final Pattern patternClass = Pattern.compile(".*/classes/(.*)\\.class$");
    static final Pattern patternXhtml = Pattern.compile(".*\\.xhtml$");
    public static Predicate<IMethod> isRelevantMethod = null;
    MutableIntSet[] reachability;
    MutableIntSet relevance;
    public Report report;
    public Report transaction;
    public int transactionId;
    public int operationId;
    public Map<Trace, Integer> callSiteToOp;
    public Map<Pair<String, String>, List<Constraint>> constraints = new LinkedHashMap<Pair<String, String>, List<Constraint>>();

    public Framework(IClassHierarchy cha, CallGraph callgraph) {
        this(cha, callgraph, false);
    }

    public Framework(IClassHierarchy cha, CallGraph callgraph, boolean usageAnalysis) {
        this.cha = cha;
        this.callgraph = callgraph;
        this.usageAnalysis = usageAnalysis;
        this.reachabilityAnalysis();
    }

    public CallGraph callgraph() {
        return this.callgraph;
    }

    public IClassHierarchy classHierarchy() {
        return this.cha;
    }

    public static String[] loadStandardLib(AnalysisScope scope, Path workDir) throws IOException {
        String javaVersion = System.getProperty("java.specification.version");
        String javaHome = System.getProperty("java.home");
        LOGGER.info("java.specification.version=" + javaVersion);
        LOGGER.info("java.home=" + javaHome);
        ArrayList<String> stdlibs = new ArrayList<String>();
        if (javaVersion.equals("1.8")) {
            Path libdir = Paths.get(System.getProperty("java.home"), "lib");
            Files.list(libdir).forEach(path -> {
                if (path.toString().endsWith(".jar")) {
                    stdlibs.add(path.toString());
                }
            });
        } else {
            Path temp = workDir.resolve("jrt");
            Path javaBase = FileSystems.getFileSystem(URI.create("jrt:/")).getPath("modules", "java.base");
            Path javaSql = FileSystems.getFileSystem(URI.create("jrt:/")).getPath("modules", "java.sql");
            Stream.concat(Files.walk(javaBase, new FileVisitOption[0]), Files.walk(javaSql, new FileVisitOption[0])).forEach(path -> {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    return;
                }
                Path copy = temp;
                for (int k = 2; k < path.getNameCount(); ++k) {
                    copy = copy.resolve(path.getName(k).toString());
                }
                try {
                    Files.createDirectories(copy.getParent(), new FileAttribute[0]);
                    Files.copy(path, copy, new CopyOption[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            stdlibs.add(temp.toString());
        }
        String[] res = new String[stdlibs.size()];
        for (int k = 0; k < res.length; ++k) {
            String stdlib;
            res[k] = stdlib = (String)stdlibs.get(k);
            if (stdlib.endsWith(".jar")) {
                scope.addToScope(ClassLoaderReference.Primordial, new JarFile(stdlib));
                continue;
            }
            scope.addToScope(ClassLoaderReference.Primordial, (Module)new BinaryDirectoryTreeModule(new File(stdlib)));
        }
        return res;
    }

    public static boolean checkMavenCentral(String sha1, String name) {
        try {
            if (name.startsWith("log4j") || name.startsWith("slf4j")) {
                return true;
            }
            HttpGet request = new HttpGet("https://search.maven.org/solrsearch/select?q=1:" + sha1 + "&rows=20&wt=json");
            request.addHeader("content-type", "application/json");
            HttpResponse response = httpClient.execute((HttpUriRequest)request);
            Map res = (Map)new ObjectMapper().readValue(response.getEntity().getContent(), Map.class);
            if (!((Map)res.get("response")).get("numFound").equals(0)) {
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.info("Failed to query central: " + name);
        }
        return false;
    }

    public static boolean checkSpringBoot(String jarFile) throws IOException, FileNotFoundException {
        JarFile jar = new JarFile(jarFile);
        return jar.getJarEntry("BOOT-INF") != null;
    }

    public static void unpackArchives(String jarFile, Path workDir, List<String> classRoots, List<String> jars) throws IOException, FileNotFoundException {
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> enumEntries = jar.entries();
        while (enumEntries.hasMoreElements()) {
            boolean mj;
            JarEntry entry = enumEntries.nextElement();
            File file = workDir.resolve(entry.getName()).toFile();
            String fileName = file.getAbsolutePath().toString();
            if (!file.exists()) {
                file.getParentFile().mkdirs();
            }
            if (mj = patternJar.matcher(fileName).find()) {
                String sha1 = DigestUtils.sha1Hex((InputStream)jar.getInputStream(entry));
                if (Framework.checkMavenCentral(sha1, file.getName())) {
                    LOGGER.info("skpping " + sha1 + " " + file.getName());
                } else {
                    jars.add(fileName);
                }
            }
            if (entry.isDirectory()) {
                boolean mcs = patternClasses.matcher(fileName).find();
                if (!mcs) continue;
                classRoots.add(fileName);
                continue;
            }
            Files.copy(jar.getInputStream(entry), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            boolean mw = patternWar.matcher(fileName).find();
            if (!mw) continue;
            String warname = entry.getName().substring(0, entry.getName().lastIndexOf("."));
            String newWorkDir = workDir + File.separator + warname;
            Framework.unpackArchives(fileName, workDir.resolve(warname), classRoots, jars);
        }
        jar.close();
    }

    public static Set<IClass> relevantJarsAnalysis(IClassHierarchy cha, Set<IClass> relevantClasses, Set<IClass> applicationClasses, Predicate<IClass> relevanceTest) {
        HashMap<String, Set<Object>> defines = new HashMap<String, Set<Object>>();
        HashMap<String, Set<Object>> references = new HashMap<String, Set<Object>>();
        HashMap deps = new HashMap();
        for (IClass c : cha) {
            if (c.getClassLoader().getReference().equals((Object)ClassLoaderReference.Primordial)) continue;
            if (!(c instanceof ShrikeClass)) {
                relevantClasses.add(c);
                applicationClasses.add(c);
                continue;
            }
            ShrikeClass sc = (ShrikeClass)c;
            ModuleEntry m = sc.getModuleEntry();
            if (!(m instanceof JarFileEntry)) {
                relevantClasses.add(c);
                applicationClasses.add(c);
                continue;
            }
            String jarName = ((JarFileEntry)m).getJarFile().getName();
            if (!defines.containsKey(jarName)) {
                defines.put(jarName, new HashSet());
            }
            ((Set)defines.get(jarName)).add(c);
            ConstantPoolParser cp = sc.getReader().getCP();
            for (int k = 1; k < cp.getItemCount(); ++k) {
                String cref;
                if (cp.getItemType(k) != 7) continue;
                try {
                    cref = cp.getCPClass(k);
                }
                catch (Exception e) {
                    continue;
                }
                IClass c2 = c.getClassLoader().lookupClass(TypeName.findOrCreate((String)("L" + cref)));
                if (c2 == null) continue;
                if (!references.containsKey(jarName)) {
                    references.put(jarName, new HashSet());
                }
                ((Set)references.get(jarName)).add(c2);
            }
        }
        ArrayList<Object> next = new ArrayList(references.keySet());
        while (!next.isEmpty()) {
            ArrayList todo = next;
            next = new ArrayList();
            for (String j : todo) {
                if (!references.containsKey(j)) {
                    references.put(j, new HashSet());
                }
                Set rs = (Set)references.get(j);
                HashSet js = new HashSet();
                for (Map.Entry e2 : defines.entrySet()) {
                    if (((String)e2.getKey()).equals(j) || !Util.any(rs, v -> ((Set)e2.getValue()).contains(v))) continue;
                    js.add(e2.getKey());
                }
                if (js.isEmpty()) continue;
                boolean mod = false;
                for (String j2 : js) {
                    Set rs2 = references.getOrDefault(j2, Collections.emptySet());
                    if (rs.containsAll(rs2)) continue;
                    rs.addAll(rs2);
                    mod = true;
                }
                if (!mod) continue;
                next.add(j);
            }
        }
        HashSet relevantJars = new HashSet();
        for (Map.Entry e : references.entrySet()) {
            if (!Util.any((Iterable)e.getValue(), relevanceTest)) continue;
            relevantJars.add(e.getKey());
        }
        LOGGER.info("Relevant jars: " + relevantJars);
        for (String jar : relevantJars) {
            relevantClasses.addAll(defines.getOrDefault(jar, Collections.emptySet()));
        }
        return relevantClasses;
    }

    public static Supplier<CallGraph> chaCgBuilder(IClassHierarchy cha, AnalysisOptions options, Iterable<? extends IMethod> entries) {
        return Framework.chaCgBuilder(cha, options, entries, m -> !m.getDeclaringClass().getClassLoader().getReference().equals((Object)ClassLoaderReference.Primordial));
    }

    public static Supplier<CallGraph> chaCgBuilder(IClassHierarchy cha, AnalysisOptions options, Iterable<? extends IMethod> entries, Predicate<IMethod> relevanceTest) {
        isRelevantMethod = relevanceTest;
        ArrayList<DefaultEntrypoint> entryPoints = new ArrayList<DefaultEntrypoint>();
        for (IMethod iMethod : entries) {
            entryPoints.add(new DefaultEntrypoint(iMethod, cha));
            for (int i = 0; i < iMethod.getNumberOfParameters(); ++i) {
                if (cha.lookupClass(iMethod.getParameterType(i)) != null) continue;
                LOGGER.fine("adding: " + iMethod.getParameterType(i));
                cha.addClass((IClass)new DivaPhantomClass(iMethod.getParameterType(i), cha));
            }
        }
        options.setEntrypoints(entryPoints);
        SSAOptions ssaOptions = new SSAOptions();
        ssaOptions.setDefaultValues(SymbolTable::getDefaultValue);
        final IRFactory iRFactory = AstIRFactory.makeDefaultFactory();
        AnalysisCache cache = new AnalysisCache(iRFactory, ssaOptions, new SSACache(iRFactory, null, (IAuxiliaryCache)new AuxiliaryCache()){
            private HashMap<Pair<IMethod, com.ibm.wala.ipa.callgraph.Context>, Map<SSAOptions, Object>> dictionary;
            {
                super(x0, x1, x2);
                this.dictionary = HashMapFactory.make();
            }

            public synchronized IR findOrCreateIR(IMethod m, com.ibm.wala.ipa.callgraph.Context c, SSAOptions options) {
                IR ir;
                if (m == null) {
                    throw new IllegalArgumentException("m is null");
                }
                if (m.isAbstract() || m.isNative()) {
                    return null;
                }
                if (iRFactory.contextIsIrrelevant(m)) {
                    c = Everywhere.EVERYWHERE;
                }
                if ((ir = this.find(m, c, options)) == null) {
                    ir = iRFactory.makeIR(m, c, options);
                    this.cache(m, c, options, ir);
                }
                return ir;
            }

            private void cache(IMethod m, com.ibm.wala.ipa.callgraph.Context c, SSAOptions options, IR ir) {
                Pair p = Pair.make((Object)m, (Object)c);
                Map methodMap = MapUtil.findOrCreateMap(this.dictionary, (Object)p);
                Object ref = CacheReference.make((Object)ir);
                methodMap.put(options, ref);
            }

            private IR find(IMethod m, com.ibm.wala.ipa.callgraph.Context c, SSAOptions options) {
                Pair p = Pair.make((Object)m, (Object)c);
                Map methodMap = MapUtil.findOrCreateMap(this.dictionary, (Object)p);
                Object ref = methodMap.get(options);
                if (ref == null || CacheReference.get(ref) == null) {
                    return null;
                }
                return (IR)CacheReference.get(ref);
            }

            public void invalidateIR(IMethod method, com.ibm.wala.ipa.callgraph.Context c) {
                this.dictionary.remove(Pair.make((Object)method, (Object)c));
            }
        });
        CHACallGraph cg = new CHACallGraph(cha, true);
        try {
            Field cgCache = CHACallGraph.class.getDeclaredField("cache");
            cgCache.setAccessible(true);
            cgCache.set(cg, cache);
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        cg.setInterpreter((Object)new DelegatingSSAContextInterpreter((SSAContextInterpreter)new AstContextInsensitiveSSAContextInterpreter(options, (IAnalysisCacheView)cache), (SSAContextInterpreter)new DefaultSSAInterpreter(options, (IAnalysisCacheView)cache)));
        return () -> {
            try {
                cg.init((Iterable)entryPoints);
                return cg;
            }
            catch (CancelException e) {
                return null;
            }
        };
    }

    public static CallGraphBuilder<InstanceKey> rtaBuilder(IClassHierarchy cha, AnalysisScope scope, AnalysisOptions options, Iterable<? extends IMethod> entries) {
        ArrayList<DefaultEntrypoint> entryPoints = new ArrayList<DefaultEntrypoint>();
        for (IMethod iMethod : entries) {
            entryPoints.add(new DefaultEntrypoint(iMethod, cha));
            for (int i = 0; i < iMethod.getNumberOfParameters(); ++i) {
                if (cha.lookupClass(iMethod.getParameterType(i)) != null) continue;
                LOGGER.fine("adding: " + iMethod.getParameterType(i));
                cha.addClass((IClass)new DivaPhantomClass(iMethod.getParameterType(i), cha));
            }
        }
        options.setEntrypoints(entryPoints);
        options.setSelector((ClassTargetSelector)new ClassHierarchyClassTargetSelector(cha));
        options.setSelector((MethodTargetSelector)new ClassHierarchyMethodTargetSelector(cha));
        SSAOptions ssaOptions = new SSAOptions();
        ssaOptions.setDefaultValues(SymbolTable::getDefaultValue);
        AnalysisCacheImpl analysisCacheImpl = new AnalysisCacheImpl(AstIRFactory.makeDefaultFactory(), ssaOptions);
        DefaultSSAInterpreter c = new DefaultSSAInterpreter(options, (IAnalysisCacheView)analysisCacheImpl);
        c = new DelegatingSSAContextInterpreter((SSAContextInterpreter)new AstContextInsensitiveSSAContextInterpreter(options, (IAnalysisCacheView)analysisCacheImpl){

            public Iterator<FieldReference> iterateFieldsRead(CGNode node) {
                if (node.getIR() == null) {
                    return Collections.emptyIterator();
                }
                return Util.map(Util.filter(() -> node.getIR().iterateNormalInstructions(), i -> i instanceof SSAGetInstruction), i -> ((SSAGetInstruction)i).getDeclaredField()).iterator();
            }

            public Iterator<FieldReference> iterateFieldsWritten(CGNode node) {
                if (node.getIR() == null) {
                    return Collections.emptyIterator();
                }
                return Util.map(Util.filter(() -> node.getIR().iterateNormalInstructions(), i -> i instanceof SSAPutInstruction), i -> ((SSAPutInstruction)i).getDeclaredField()).iterator();
            }
        }, (SSAContextInterpreter)c);
        c = new DelegatingSSAContextInterpreter(ReflectionContextInterpreter.createReflectionContextInterpreter((IClassHierarchy)cha, (AnalysisOptions)options, (IAnalysisCacheView)analysisCacheImpl), (SSAContextInterpreter)c);
        DefaultContextSelector def = new DefaultContextSelector(options, cha);
        BasicRTABuilder builder = new BasicRTABuilder(cha, options, (IAnalysisCacheView)analysisCacheImpl, (ContextSelector)def, (SSAContextInterpreter)c);
        return builder;
    }

    public static CallGraphBuilder<InstanceKey> cfaBuilder(IClassHierarchy cha, AnalysisScope scope, AnalysisOptions options, Iterable<? extends IMethod> entries) {
        ArrayList<DefaultEntrypoint> entryPoints = new ArrayList<DefaultEntrypoint>();
        for (IMethod iMethod : entries) {
            entryPoints.add(new DefaultEntrypoint(iMethod, cha));
            for (int i = 0; i < iMethod.getNumberOfParameters(); ++i) {
                if (cha.lookupClass(iMethod.getParameterType(i)) != null) continue;
                LOGGER.fine("adding: " + iMethod.getParameterType(i));
                cha.addClass((IClass)new DivaPhantomClass(iMethod.getParameterType(i), cha));
            }
        }
        options.setEntrypoints(entryPoints);
        SSAOptions ssaOptions = new SSAOptions();
        ssaOptions.setDefaultValues(SymbolTable::getDefaultValue);
        AnalysisCacheImpl analysisCacheImpl = new AnalysisCacheImpl(AstIRFactory.makeDefaultFactory(), ssaOptions);
        AstJavaZeroXCFABuilder builder = new ZeroCFABuilderFactory().make(options, (IAnalysisCacheView)analysisCacheImpl, cha, scope);
        return builder;
    }

    public void reachabilityAnalysis() {
        this.reachability = new MutableIntSet[this.callgraph().getNumberOfNodes()];
        BitVectorIntSet todo = new BitVectorIntSet();
        for (CGNode n : this.callgraph()) {
            this.reachability[n.getGraphNodeId()] = new BimodalMutableIntSet();
            todo.add(n.getGraphNodeId());
        }
        while (!todo.isEmpty()) {
            BitVectorIntSet next = new BitVectorIntSet();
            for (CGNode n : this.callgraph()) {
                boolean t = false;
                MutableIntSet rs = this.reachability[n.getGraphNodeId()];
                for (CallSiteReference site : () -> n.iterateCallSites()) {
                    String klazz = site.getDeclaredTarget().getDeclaringClass().getName().toString();
                    if (klazz.startsWith("Ljava/") || klazz.startsWith("Ljavax/")) continue;
                    for (CGNode m : this.callgraph().getPossibleTargets(n, site)) {
                        if (!todo.contains(m.getGraphNodeId())) continue;
                        t |= rs.add(m.getGraphNodeId());
                        t |= rs.addAll((IntSet)this.reachability[m.getGraphNodeId()]);
                    }
                }
                if (!t) continue;
                next.add(n.getGraphNodeId());
            }
            todo = next;
        }
        LOGGER.info("Done: reachability analysis");
    }

    public boolean isReachable(CGNode from, CGNode to) {
        return from == to || this.reachability[from.getGraphNodeId()].contains(to.getGraphNodeId());
    }

    public void traverse(CGNode entry, Trace.Visitor visitor) {
        this.traverse(new Trace(entry, null), visitor, false);
    }

    public void traverse(Trace trace0, Trace.Visitor visitor, boolean pathSensitive) {
        BitVectorIntSet visited = null;
        if (!pathSensitive) {
            visited = new BitVectorIntSet();
        }
        Stack<Trace> stack = new Stack<Trace>();
        Stack<Iterator> iters = new Stack<Iterator>();
        stack.push(trace0);
        CGNode entry = trace0.node();
        iters.push(entry.getMethod() instanceof FakeRootMethod ? entry.iterateCallSites() : entry.getIR().iterateAllInstructions());
        if (!pathSensitive) {
            visited.add(entry.getGraphNodeId());
        }
        visitor.visitNode((Trace)stack.peek());
        block0: while (!stack.isEmpty()) {
            CallSiteReference site;
            if (Thread.interrupted()) {
                throw new RuntimeException("Diva interrupted");
            }
            Trace trace = (Trace)stack.peek();
            if (!((Iterator)iters.peek()).hasNext()) {
                trace = trace.updateSite(null);
                visitor.visitExit(trace);
                stack.pop();
                iters.pop();
                continue;
            }
            Object o = ((Iterator)iters.peek()).next();
            if (o == null) continue;
            if (o instanceof SSAInstruction) {
                SSAInstruction instr = (SSAInstruction)o;
                if (instr instanceof SSAPhiInstruction || !trace.in(this, instr)) continue;
                visitor.visitInstruction(trace, instr);
                if (!(instr instanceof SSAAbstractInvokeInstruction)) continue;
                site = ((SSAAbstractInvokeInstruction)instr).getCallSite();
            } else {
                if (!(o instanceof CallSiteReference)) continue;
                site = (CallSiteReference)o;
            }
            trace = trace.updateSite(site);
            visitor.visitCallSite(trace);
            String klazz = site.getDeclaredTarget().getDeclaringClass().getName().toString();
            if (klazz.startsWith("Ljava/") || klazz.startsWith("Ljavax/")) continue;
            Trace targetTrace = null;
            if (trace.callLog() != null) {
                targetTrace = trace.callLog().getOrDefault(site, null);
            }
            if (targetTrace != null) {
                stack.push(targetTrace);
                iters.push(targetTrace.node().getIR().iterateAllInstructions());
                continue;
            }
            Set<CGNode> targets = this.getFilteredTargets(trace, site);
            if (targets.isEmpty()) continue;
            if (targets.size() > 1) {
                LOGGER.fine("Failing to determine target for " + site);
            }
            for (CGNode n : targets) {
                if (pathSensitive) {
                    if (Util.any(trace, t -> t.node().getGraphNodeId() == n.getGraphNodeId())) {
                        continue;
                    }
                } else {
                    if (visited.contains(n.getGraphNodeId())) continue;
                    visited.add(n.getGraphNodeId());
                }
                stack.push(new Trace(n, trace));
                iters.push(n.getIR().iterateAllInstructions());
                trace.logCall((Trace)stack.peek());
                visitor.visitNode((Trace)stack.peek());
                if (!pathSensitive) continue;
                continue block0;
            }
        }
    }

    public Set<CGNode> getFilteredTargets(Trace trace, CallSiteReference site) {
        SSAAbstractInvokeInstruction instr;
        IClass self;
        Set<CGNode> targets = this.callgraph.getPossibleTargets(trace.node(), site);
        if (targets.isEmpty()) {
            return targets;
        }
        if (Util.any(targets, n -> n.getIR() == null)) {
            targets = Util.makeSet(Util.filter(targets, n -> n.getIR() != null));
        }
        if (targets.size() > 1 && trace.context() != null && !trace.context().dispatchMap().isEmpty()) {
            IClass c = this.classHierarchy().lookupClass(site.getDeclaredTarget().getDeclaringClass());
            block0: for (Map.Entry<IClass, IClass> e : trace.context().dispatchMap().entrySet()) {
                if (e.getKey() != c && !Util.any(e.getKey().isInterface() ? c.getAllImplementedInterfaces() : Util.superChain(c), i -> i == e.getKey())) continue;
                for (IClass d : Util.superChain(e.getValue())) {
                    Set<CGNode> ts = Util.makeSet(Util.filter(targets, n -> n.getMethod().getDeclaringClass() == d));
                    if (ts.isEmpty()) continue;
                    targets = ts;
                    break block0;
                }
            }
        }
        if (targets.size() > 1 && trace.node().getGraphNodeId() != 0 && (self = trace.inferType(this, (instr = trace.instrFromSite(site)).getUse(0))) != null) {
            targets = Util.makeSet(Util.filter(targets, n -> {
                IClass c = n.getMethod().getDeclaringClass();
                return Util.any(self.isInterface() ? c.getAllImplementedInterfaces() : Util.superChain(c), i -> i == self);
            }));
        }
        if (targets.size() > 1) {
            for (CGNode m : targets) {
                if (site.getDeclaredTarget() != m.getMethod().getReference()) continue;
                return Collections.singleton(m);
            }
        }
        return targets;
    }

    public boolean isRelevant(CGNode from) {
        if (this.relevance == null) {
            return true;
        }
        if (this.relevance.contains(from.getGraphNodeId())) {
            return true;
        }
        MutableIntSet reachable = this.reachability[from.getGraphNodeId()];
        if (reachable == null) {
            return false;
        }
        return reachable.containsAny((IntSet)this.relevance);
    }

    public void relevanceAnalysis(final Predicate<IClass> ... tests) {
        this.relevance = new BitVectorIntSet();
        this.traverse((CGNode)this.callgraph().getNode(0), new Trace.InstructionVisitor(){

            @Override
            public void visitInstruction(Trace trace, SSAInstruction instr) {
                if (!(instr instanceof SSAAbstractInvokeInstruction)) {
                    return;
                }
                if (Framework.this.relevance.contains(trace.node().getGraphNodeId())) {
                    return;
                }
                TypeReference ref = ((SSAAbstractInvokeInstruction)instr).getDeclaredTarget().getDeclaringClass();
                IClass c = Framework.this.cha.lookupClass(ref);
                if (c == null) {
                    return;
                }
                for (Predicate t : tests) {
                    if (!t.test(c)) continue;
                    Framework.this.relevance.add(trace.node().getGraphNodeId());
                    return;
                }
            }
        });
    }

    public void reportOperation(Trace trace, Consumer<Report.Named> named, IntSet uses) {
        if (this.transaction == null) {
            this.report.add(map -> {
                map.put("txid", this.transactionId++);
                map.put("transaction", v -> {
                    this.transaction = v;
                });
            });
        }
        this.transaction.add(map -> {
            if (trace.site() != null) {
                this.callSiteToOp.put(trace, this.operationId);
            }
            map.put("opid", this.operationId++);
            map.put("stacktrace", trace, _trace -> stacktrace -> {
                for (Trace t : _trace.reversed()) {
                    IMethod m = t.node().getMethod();
                    IMethod.SourcePosition p = null;
                    try {
                        p = m.getSourcePosition(t.site().getProgramCounter());
                    }
                    catch (InvalidClassFileException | NullPointerException throwable) {
                        // empty catch block
                    }
                    IMethod.SourcePosition pos = p;
                    stacktrace.add(site -> {
                        site.put("method", m.toString());
                        site.put("file", m.getDeclaringClass().getSourceFileName());
                        site.put("position", "" + pos);
                    });
                }
            });
            named.accept(map);
            if (uses != null && !uses.isEmpty()) {
                map.put("uses", r -> uses.foreach(i -> r.add(i)));
            }
        });
    }

    public void reportOperation(Trace trace, Consumer<Report.Named> named) {
        this.reportOperation(trace, named, null);
    }

    public void reportSqlStatement(Trace trace, String stmt) {
        this.reportOperation(trace, map -> map.put("sql", stmt));
    }

    public void reportSqlStatement(Trace trace, String stmt, IntSet uses) {
        this.reportOperation(trace, map -> map.put("sql", stmt), uses);
    }

    public void reportTxBoundary() {
        if (this.transaction != null) {
            this.transaction = null;
        }
    }

    public boolean txStarted() {
        return this.transaction != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateTransactionsWithTimeout(CGNode entry, Context cxt, Report report, Trace.Visitor visitor) {
        Thread current = Thread.currentThread();
        ExecutorService threadPool = Executors.newFixedThreadPool(1);
        Future<?> future = threadPool.submit(() -> {
            try {
                Thread.sleep(60000L);
                current.interrupt();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        try {
            this.calculateTransactions(entry, cxt, report, visitor);
        }
        finally {
            while (!future.isDone() && !future.cancel(true)) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            Thread.interrupted();
            threadPool.shutdown();
        }
    }

    public void calculateTransactions(CGNode entry, Context cxt, Report report, Trace.Visitor visitor) {
        this.report = report;
        this.transactionId = 0;
        this.operationId = 0;
        this.callSiteToOp = new HashMap<Trace, Integer>();
        this.traverse(new Trace(entry, null), visitor, true);
        if (this.txStarted()) {
            this.reportTxBoundary();
        }
    }

    public void calculateTransactionsWithTimeout(CGNode entry, Context cxt, Report report) {
        this.calculateTransactionsWithTimeout(entry, cxt, report, JDBCAnalysis.getTransactionAnalysis(this, cxt).with(SpringBootAnalysis.getTransactionAnalysis(this, cxt).with(JPAAnalysis.getTransactionAnalysis(this, cxt))));
    }

    public void calculateTransactions(CGNode entry, Context cxt, Report report) {
        this.calculateTransactions(entry, cxt, report, JDBCAnalysis.getTransactionAnalysis(this, cxt).with(SpringBootAnalysis.getTransactionAnalysis(this, cxt).with(JPAAnalysis.getTransactionAnalysis(this, cxt))));
    }

    public void recordContraint(Constraint c) {
        Pair key = Pair.make((Object)c.category(), (Object)c.type());
        if (!this.constraints.containsKey(key)) {
            this.constraints.put((Pair<String, String>)key, new ArrayList());
        }
        this.constraints.get(key).add(c);
    }
}

