/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.ElementValueTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.HasContainerHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.HasStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.OrStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.NoOpBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.OrderGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ElementValueComparator;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.graphdb.query.QueryUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphStep;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphTraversalUtil;
import org.javatuples.Pair;

public interface HasStepFolder<S, E>
extends Step<S, E> {
    public void addAll(Iterable<HasContainer> var1);

    public List<HasContainer> addLocalAll(Iterable<HasContainer> var1);

    public void orderBy(String var1, Order var2);

    public void localOrderBy(List<HasContainer> var1, String var2, Order var3);

    public void setLimit(int var1, int var2);

    public void setLocalLimit(List<HasContainer> var1, int var2, int var3);

    public int getLowLimit();

    public int getLocalLowLimit(List<HasContainer> var1);

    public int getHighLimit();

    public int getLocalHighLimit(List<HasContainer> var1);

    public static boolean validJanusGraphHas(HasContainer has) {
        if (has.getPredicate() instanceof ConnectiveP) {
            List predicates = ((ConnectiveP)has.getPredicate()).getPredicates();
            return predicates.stream().allMatch(p -> HasStepFolder.validJanusGraphHas(new HasContainer(has.getKey(), p)));
        }
        return JanusGraphPredicate.Converter.supports(has.getBiPredicate());
    }

    public static boolean validJanusGraphHas(Iterable<HasContainer> has) {
        for (HasContainer h : has) {
            if (HasStepFolder.validJanusGraphHas(h)) continue;
            return false;
        }
        return true;
    }

    public static boolean validJanusGraphOrder(OrderGlobalStep orderGlobalStep, Traversal rootTraversal, boolean isVertexOrder) {
        List comparators = orderGlobalStep.getComparators();
        for (Pair comp : comparators) {
            JanusGraphTransaction tx;
            PropertyKey pKey;
            String key;
            if (comp.getValue0() instanceof ElementValueTraversal && comp.getValue1() instanceof Order) {
                key = ((ElementValueTraversal)comp.getValue0()).getPropertyKey();
            } else if (comp.getValue1() instanceof ElementValueComparator) {
                ElementValueComparator evc = (ElementValueComparator)comp.getValue1();
                if (!(evc.getValueComparator() instanceof Order)) {
                    return false;
                }
                key = evc.getPropertyKey();
            } else {
                return false;
            }
            if ((pKey = (tx = JanusGraphTraversalUtil.getTx(rootTraversal.asAdmin())).getPropertyKey(key)) != null && Comparable.class.isAssignableFrom(pKey.dataType()) && (!isVertexOrder || pKey.cardinality() == Cardinality.SINGLE)) continue;
            return false;
        }
        return true;
    }

    public static void foldInIds(HasStepFolder janusgraphStep, Traversal.Admin<?, ?> traversal) {
        Step currentStep = janusgraphStep.getNextStep();
        while (true) {
            if (currentStep instanceof HasContainerHolder) {
                HasContainerHolder hasContainerHolder = (HasContainerHolder)currentStep;
                GraphStep graphStep = (GraphStep)janusgraphStep;
                ArrayList removableHasContainers = new ArrayList();
                Set stepLabels = currentStep.getLabels();
                hasContainerHolder.getHasContainers().forEach(hasContainer -> {
                    if (GraphStep.processHasContainerIds((GraphStep)graphStep, (HasContainer)hasContainer)) {
                        stepLabels.forEach(arg_0 -> ((HasStepFolder)janusgraphStep).addLabel(arg_0));
                        removableHasContainers.add(hasContainer);
                    }
                });
                if (!removableHasContainers.isEmpty()) {
                    removableHasContainers.forEach(arg_0 -> ((HasContainerHolder)hasContainerHolder).removeHasContainer(arg_0));
                }
                if (hasContainerHolder.getHasContainers().isEmpty()) {
                    traversal.removeStep(currentStep);
                }
            } else if (!(currentStep instanceof IdentityStep) && !(currentStep instanceof NoOpBarrierStep)) break;
            currentStep = currentStep.getNextStep();
        }
    }

    public static void foldInHasContainer(HasStepFolder janusgraphStep, Traversal.Admin<?, ?> traversal, Traversal<?, ?> rootTraversal) {
        Step currentStep = janusgraphStep.getNextStep();
        while (true) {
            if (currentStep instanceof OrStep && janusgraphStep instanceof JanusGraphStep) {
                for (Traversal.Admin child : ((OrStep)currentStep).getLocalChildren()) {
                    if (HasStepFolder.validFoldInHasContainer(child.getStartStep(), false)) continue;
                    return;
                }
                ((OrStep)currentStep).getLocalChildren().forEach(t -> HasStepFolder.localFoldInHasContainer(janusgraphStep, t.getStartStep(), t, rootTraversal));
                traversal.removeStep(currentStep);
            } else if (currentStep instanceof HasContainerHolder) {
                Iterable containers = ((HasContainerHolder)currentStep).getHasContainers().stream().map(c -> JanusGraphPredicate.Converter.convert(c)).collect(Collectors.toList());
                if (HasStepFolder.validFoldInHasContainer(currentStep, true)) {
                    janusgraphStep.addAll(containers);
                    currentStep.getLabels().forEach(arg_0 -> ((HasStepFolder)janusgraphStep).addLabel(arg_0));
                    traversal.removeStep(currentStep);
                }
            } else if (!(currentStep instanceof IdentityStep) && !(currentStep instanceof NoOpBarrierStep) && !(currentStep instanceof HasContainerHolder)) break;
            currentStep = currentStep.getNextStep();
        }
    }

    public static void localFoldInHasContainer(HasStepFolder janusgraphStep, Step<?, ?> tinkerpopStep, Traversal.Admin<?, ?> traversal, Traversal<?, ?> rootTraversal) {
        Step<?, ?> currentStep = tinkerpopStep;
        while (true) {
            if (currentStep instanceof HasContainerHolder) {
                Iterable containers = ((HasContainerHolder)currentStep).getHasContainers().stream().map(c -> JanusGraphPredicate.Converter.convert(c)).collect(Collectors.toList());
                List<HasContainer> hasContainers = janusgraphStep.addLocalAll(containers);
                currentStep.getLabels().forEach(arg_0 -> ((HasStepFolder)janusgraphStep).addLabel(arg_0));
                traversal.removeStep((Step)currentStep);
                currentStep = HasStepFolder.foldInOrder(janusgraphStep, currentStep, traversal, rootTraversal, janusgraphStep instanceof JanusGraphStep && ((JanusGraphStep)janusgraphStep).returnsVertex(), hasContainers);
                HasStepFolder.foldInRange(janusgraphStep, currentStep, traversal, hasContainers);
            } else if (!(currentStep instanceof IdentityStep) && !(currentStep instanceof NoOpBarrierStep)) break;
            currentStep = currentStep.getNextStep();
        }
    }

    public static boolean validFoldInHasContainer(Step<?, ?> tinkerpopStep, boolean defaultValue) {
        Step currentStep = tinkerpopStep;
        Boolean toReturn = null;
        while (!(currentStep instanceof EmptyStep)) {
            if (currentStep instanceof HasContainerHolder) {
                List containers = ((HasContainerHolder)currentStep).getHasContainers();
                toReturn = toReturn == null ? HasStepFolder.validJanusGraphHas(containers) : toReturn != false && HasStepFolder.validJanusGraphHas(containers);
            } else if (!(currentStep instanceof IdentityStep || currentStep instanceof NoOpBarrierStep || currentStep instanceof RangeGlobalStep || currentStep instanceof OrderGlobalStep)) {
                toReturn = toReturn == null ? false : toReturn != false && defaultValue;
                break;
            }
            currentStep = currentStep.getNextStep();
        }
        return Boolean.TRUE.equals(toReturn);
    }

    public static Step<?, ?> foldInOrder(HasStepFolder janusgraphStep, Step<?, ?> tinkerpopStep, Traversal.Admin<?, ?> traversal, Traversal<?, ?> rootTraversal, boolean isVertexOrder, List<HasContainer> hasContainers) {
        Step currentStep = tinkerpopStep;
        OrderGlobalStep lastOrder = null;
        while (true) {
            if (currentStep instanceof OrderGlobalStep) {
                if (lastOrder != null) {
                    lastOrder.getLabels().forEach(arg_0 -> ((HasStepFolder)janusgraphStep).addLabel(arg_0));
                    traversal.removeStep((Step)lastOrder);
                }
                lastOrder = (OrderGlobalStep)currentStep;
            } else if (!(currentStep instanceof IdentityStep) && !(currentStep instanceof HasStep) && !(currentStep instanceof NoOpBarrierStep)) break;
            currentStep = currentStep.getNextStep();
        }
        if (lastOrder != null && HasStepFolder.validJanusGraphOrder(lastOrder, rootTraversal, isVertexOrder)) {
            for (Pair comp : lastOrder.getComparators()) {
                Order order;
                String key;
                if (comp.getValue0() instanceof ElementValueTraversal) {
                    ElementValueTraversal evt = (ElementValueTraversal)comp.getValue0();
                    key = evt.getPropertyKey();
                    order = (Order)comp.getValue1();
                } else {
                    ElementValueComparator evc = (ElementValueComparator)comp.getValue1();
                    key = evc.getPropertyKey();
                    order = (Order)evc.getValueComparator();
                }
                if (hasContainers == null) {
                    janusgraphStep.orderBy(key, order);
                    continue;
                }
                janusgraphStep.localOrderBy(hasContainers, key, order);
            }
            lastOrder.getLabels().forEach(arg_0 -> ((HasStepFolder)janusgraphStep).addLabel(arg_0));
            traversal.removeStep((Step)lastOrder);
        }
        return currentStep;
    }

    public static List<HasContainer> splitAndP(List<HasContainer> hasContainers, Iterable<HasContainer> has) {
        has.forEach(hasContainer -> {
            if (hasContainer.getPredicate() instanceof AndP) {
                for (P predicate : ((AndP)hasContainer.getPredicate()).getPredicates()) {
                    hasContainers.add(new HasContainer(hasContainer.getKey(), predicate));
                }
            } else {
                hasContainers.add((HasContainer)hasContainer);
            }
        });
        return hasContainers;
    }

    public static void foldInRange(HasStepFolder janusgraphStep, Step<?, ?> tinkerpopStep, Traversal.Admin<?, ?> traversal, List<HasContainer> hasContainers) {
        block6: {
            Step nextStep;
            block7: {
                Step step = nextStep = tinkerpopStep instanceof IdentityStep ? JanusGraphTraversalUtil.getNextNonIdentityStep(tinkerpopStep) : tinkerpopStep;
                if (!(nextStep instanceof RangeGlobalStep)) break block6;
                RangeGlobalStep range = (RangeGlobalStep)nextStep;
                int low = 0;
                if (janusgraphStep instanceof JanusGraphStep) {
                    low = QueryUtil.convertLimit(range.getLowRange());
                    low = QueryUtil.mergeLowLimits(low, hasContainers == null ? janusgraphStep.getLowLimit() : janusgraphStep.getLocalLowLimit(hasContainers));
                }
                int high = QueryUtil.convertLimit(range.getHighRange());
                high = QueryUtil.mergeHighLimits(high, hasContainers == null ? janusgraphStep.getHighLimit() : janusgraphStep.getLocalHighLimit(hasContainers));
                if (hasContainers == null) {
                    janusgraphStep.setLimit(low, high);
                } else {
                    janusgraphStep.setLocalLimit(hasContainers, low, high);
                }
                if (janusgraphStep instanceof JanusGraphStep) break block7;
                if (range.getLowRange() != 0L) break block6;
            }
            nextStep.getLabels().forEach(arg_0 -> ((HasStepFolder)janusgraphStep).addLabel(arg_0));
            traversal.removeStep(nextStep);
        }
    }

    public static class OrderEntry {
        public final String key;
        public final Order order;

        public OrderEntry(String key, Order order) {
            this.key = key;
            this.order = order;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OrderEntry that = (OrderEntry)o;
            if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
                return false;
            }
            return this.order == that.order;
        }

        public int hashCode() {
            int result = this.key != null ? this.key.hashCode() : 0;
            result = 31 * result + (this.order != null ? this.order.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "OrderEntry{key='" + this.key + '\'' + ", order=" + this.order + '}';
        }
    }
}

