/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.janusgraph.core.JanusGraphElement;

public class ResultSetIterator<R extends JanusGraphElement>
implements Iterator<R> {
    private final Iterator<R> iterator;
    private final int limit;
    private R current;
    private R next;
    private int count;

    public ResultSetIterator(Iterator<R> inner, int limit) {
        this.iterator = inner;
        this.limit = limit;
        this.count = 0;
        this.current = null;
        this.next = this.nextInternal();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    private R nextInternal() {
        JanusGraphElement r = null;
        if (this.count < this.limit && this.iterator.hasNext()) {
            r = (JanusGraphElement)this.iterator.next();
        }
        return (R)r;
    }

    @Override
    public R next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.current = this.next;
        ++this.count;
        this.next = this.nextInternal();
        return this.current;
    }

    @Override
    public void remove() {
        if (this.current == null) {
            throw new UnsupportedOperationException();
        }
        this.current.remove();
    }

    public static <R extends JanusGraphElement> Iterable<R> wrap(Iterable<R> inner, int limit) {
        return () -> new ResultSetIterator(inner.iterator(), limit);
    }
}

