/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.management;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.SchemaAction;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.database.management.ManagementSystem;
import org.janusgraph.graphdb.management.utils.ConfigurationManagementGraphAlreadyInstantiatedException;
import org.janusgraph.graphdb.management.utils.ConfigurationManagementGraphNotEnabledException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationManagementGraph {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationManagementGraph.class);
    private static ConfigurationManagementGraph instance = null;
    public static final String PROPERTY_GRAPH_NAME = GraphDatabaseConfiguration.GRAPH_NAME.toStringWithoutRoot();
    public static final String PROPERTY_CREATED_USING_TEMPLATE = "Created_Using_Template";
    private static final String VERTEX_LABEL = "Configuration";
    private static final String GRAPH_NAME_INDEX = "Graph_Name_Index";
    private static final String PROPERTY_TEMPLATE = "Template_Configuration";
    private static final String TEMPLATE_INDEX = "Template_Index";
    private static final String CREATED_USING_TEMPLATE_INDEX = "Created_Using_Template_Index";
    private final StandardJanusGraph graph;

    public ConfigurationManagementGraph(StandardJanusGraph graph) {
        this.initialize();
        this.graph = graph;
        this.createIndexIfDoesNotExist(GRAPH_NAME_INDEX, PROPERTY_GRAPH_NAME, String.class, true);
        this.createIndexIfDoesNotExist(TEMPLATE_INDEX, PROPERTY_TEMPLATE, Boolean.class, false);
        this.createIndexIfDoesNotExist(CREATED_USING_TEMPLATE_INDEX, PROPERTY_CREATED_USING_TEMPLATE, Boolean.class, false);
    }

    private synchronized void initialize() {
        if (null != instance) {
            String errMsg = "ConfigurationManagementGraph should be instantiated just once, by the JanusGraphManager.";
            throw new ConfigurationManagementGraphAlreadyInstantiatedException("ConfigurationManagementGraph should be instantiated just once, by the JanusGraphManager.");
        }
        instance = this;
    }

    public static ConfigurationManagementGraph getInstance() throws ConfigurationManagementGraphNotEnabledException {
        if (null == instance) {
            throw new ConfigurationManagementGraphNotEnabledException("Please add a key named \"ConfigurationManagementGraph\" to the \"graphs\" property in your YAML file and restart the server to be able to use the functionality of the ConfigurationManagementGraph class.");
        }
        return instance;
    }

    public void createConfiguration(Configuration config) {
        Preconditions.checkArgument((boolean)config.containsKey(PROPERTY_GRAPH_NAME), (Object)String.format("Please include the property \"%s\" in your configuration.", PROPERTY_GRAPH_NAME));
        Map map = ConfigurationConverter.getMap((Configuration)config);
        JanusGraphVertex v = this.graph.addVertex(T.label, VERTEX_LABEL);
        map.forEach((key, value) -> v.property((String)key, value));
        v.property(PROPERTY_TEMPLATE, false);
        this.graph.tx().commit();
    }

    public void createTemplateConfiguration(Configuration config) {
        Preconditions.checkArgument((!config.containsKey(PROPERTY_GRAPH_NAME) ? 1 : 0) != 0, (Object)String.format("Your template configuration may not contain the property \"%s\".", PROPERTY_GRAPH_NAME));
        Preconditions.checkState((null == this.getTemplateConfiguration() ? 1 : 0) != 0, (Object)"You may only have one template configuration and one exists already.");
        Map map = ConfigurationConverter.getMap((Configuration)config);
        JanusGraphVertex v = this.graph.addVertex(new Object[0]);
        v.property(PROPERTY_TEMPLATE, true);
        map.forEach((key, value) -> v.property((String)key, value));
        this.graph.tx().commit();
    }

    public void updateConfiguration(String graphName, Configuration config) {
        Map map = ConfigurationConverter.getMap((Configuration)config);
        if (config.containsKey(PROPERTY_GRAPH_NAME)) {
            String graphNameOnConfig = (String)map.get(PROPERTY_GRAPH_NAME);
            Preconditions.checkArgument((boolean)graphName.equals(graphNameOnConfig), (Object)String.format("Supplied graphName %s does not match property value supplied on config: %s.", graphName, graphNameOnConfig));
        } else {
            map.put(PROPERTY_GRAPH_NAME, graphName);
        }
        log.warn("Configuration {} is only guaranteed to take effect when graph {} has been closed and reopened on all Janus Graph Nodes.", (Object)graphName, (Object)graphName);
        this.updateVertexWithProperties(PROPERTY_GRAPH_NAME, graphName, map);
    }

    public void updateTemplateConfiguration(Configuration config) {
        Preconditions.checkArgument((!config.containsKey(PROPERTY_GRAPH_NAME) ? 1 : 0) != 0, (Object)String.format("Your updated template configuration may not contain the property \"%s\".", PROPERTY_GRAPH_NAME));
        log.warn("Any graph configuration created using the template configuration are only guaranteed to have their configuration updated according to this new template configuration when the graph in question has been closed on every Janus Graph Node, its corresponding Configuration has been removed, and the graph has been recreated.");
        this.updateVertexWithProperties(PROPERTY_TEMPLATE, true, ConfigurationConverter.getMap((Configuration)config));
    }

    public void removeConfiguration(String graphName) {
        this.removeVertex(PROPERTY_GRAPH_NAME, graphName);
    }

    public void removeTemplateConfiguration() {
        this.removeVertex(PROPERTY_TEMPLATE, true);
    }

    public Map<String, Object> getConfiguration(String configName) {
        List graphConfiguration = this.graph.traversal().V(new Object[0]).has(PROPERTY_GRAPH_NAME, (Object)configName).valueMap(new String[0]).toList();
        if (graphConfiguration.isEmpty()) {
            return null;
        }
        if (graphConfiguration.size() > 1) {
            log.warn("Your configuration management graph is an a bad state. Please ensure you have just one configuration per graph. The behavior of the class' APIs are henceforth unpredictable until this is fixed.");
        }
        return this.deserializeVertexProperties((Map)graphConfiguration.get(0));
    }

    public List<Map<String, Object>> getConfigurations() {
        List graphConfigurations = this.graph.traversal().V(new Object[0]).has(PROPERTY_TEMPLATE, (Object)false).valueMap(new String[0]).toList();
        return graphConfigurations.stream().map(this::deserializeVertexProperties).collect(Collectors.toList());
    }

    public Map<String, Object> getTemplateConfiguration() {
        List templateConfigurations = this.graph.traversal().V(new Object[0]).has(PROPERTY_TEMPLATE, (Object)true).valueMap(new String[0]).toList();
        if (templateConfigurations.size() == 0) {
            return null;
        }
        if (templateConfigurations.size() > 1) {
            log.warn("Your configuration management graph is an a bad state. Please ensure you have just one template configuration. The behavior of the class' APIs are henceforth unpredictable until this is fixed.");
        }
        ((Map)templateConfigurations.get(0)).remove(PROPERTY_TEMPLATE);
        return this.deserializeVertexProperties((Map)templateConfigurations.get(0));
    }

    private void removeVertex(String property, Object value) {
        GraphTraversal traversal = this.graph.traversal().V(new Object[0]).has(property, value);
        if (traversal.hasNext()) {
            ((Vertex)traversal.next()).remove();
            this.graph.tx().commit();
        }
    }

    private void createIndexIfDoesNotExist(String indexName, String propertyKeyName, Class dataType, boolean unique) {
        this.graph.tx().rollback();
        JanusGraphManagement management = this.graph.openManagement();
        if (null == management.getGraphIndex(indexName)) {
            PropertyKey key;
            boolean propertyKeyAlreadyExisted = false;
            if (null == management.getPropertyKey(propertyKeyName)) {
                key = management.makePropertyKey(propertyKeyName).dataType(dataType).make();
            } else {
                key = management.getPropertyKey(propertyKeyName);
                propertyKeyAlreadyExisted = true;
            }
            JanusGraphIndex index = unique ? management.buildIndex(indexName, Vertex.class).addKey(key).unique().buildCompositeIndex() : management.buildIndex(indexName, Vertex.class).addKey(key).buildCompositeIndex();
            try {
                if (index.getIndexStatus(key) == SchemaStatus.INSTALLED) {
                    management.commit();
                    ManagementSystem.awaitGraphIndexStatus(this.graph, indexName).call();
                    management = this.graph.openManagement();
                    if (propertyKeyAlreadyExisted) {
                        management.updateIndex(management.getGraphIndex(indexName), SchemaAction.REINDEX).get();
                    } else {
                        management.updateIndex(management.getGraphIndex(indexName), SchemaAction.ENABLE_INDEX).get();
                    }
                } else if (index.getIndexStatus(key) == SchemaStatus.REGISTERED) {
                    if (propertyKeyAlreadyExisted) {
                        management.updateIndex(management.getGraphIndex(indexName), SchemaAction.REINDEX).get();
                    } else {
                        management.updateIndex(management.getGraphIndex(indexName), SchemaAction.ENABLE_INDEX).get();
                    }
                }
            }
            catch (InterruptedException | ExecutionException e) {
                log.warn("Failed to create index {} for ConfigurationManagementGraph with exception: {}", (Object)indexName, (Object)e.toString());
                management.rollback();
                this.graph.tx().rollback();
            }
            management.commit();
            this.graph.tx().commit();
        }
    }

    private void updateVertexWithProperties(String propertyKey, Object propertyValue, Map<Object, Object> map) {
        if (this.graph.traversal().V(new Object[0]).has(propertyKey, propertyValue).hasNext()) {
            Vertex v = (Vertex)this.graph.traversal().V(new Object[0]).has(propertyKey, propertyValue).next();
            map.forEach((key, value) -> v.property((String)key, value));
            this.graph.tx().commit();
        }
    }

    private Map<String, Object> deserializeVertexProperties(Map<String, Object> map) {
        map.forEach((key, value) -> {
            if (value instanceof List) {
                if (((List)value).size() > 1) {
                    log.warn("Your configuration management graph is an a bad state. Please ensure each vertex property is not supplied a Collection as a value. The behavior of the class' APIs are henceforth unpredictable until this is fixed.");
                }
                map.put((String)key, ((List)value).get(0));
            }
        });
        return map;
    }
}

