/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.configuration;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.ConfigNamespace;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;

public abstract class AbstractConfiguration
implements Configuration {
    private final ConfigNamespace root;

    protected AbstractConfiguration(ConfigNamespace root) {
        Preconditions.checkNotNull((Object)root);
        Preconditions.checkArgument((!root.isUmbrella() ? 1 : 0) != 0, (Object)"Root cannot be an umbrella namespace");
        this.root = root;
    }

    public ConfigNamespace getRootNamespace() {
        return this.root;
    }

    protected void verifyElement(ConfigElement element) {
        Preconditions.checkNotNull((Object)element);
        Preconditions.checkArgument((boolean)element.getRoot().equals(this.root), (String)"Configuration element is not associated with this configuration: %s", (Object[])new Object[]{element});
    }

    protected String getPath(ConfigElement option, String ... umbrellaElements) {
        this.verifyElement(option);
        return ConfigElement.getPath(option, umbrellaElements);
    }

    protected Set<String> getContainedNamespaces(ReadConfiguration config, ConfigNamespace umbrella, String ... umbrellaElements) {
        this.verifyElement(umbrella);
        Preconditions.checkArgument((boolean)umbrella.isUmbrella());
        String prefix = ConfigElement.getPath((ConfigElement)umbrella, umbrellaElements);
        HashSet result = Sets.newHashSet();
        for (String key : config.getKeys(prefix)) {
            Preconditions.checkArgument((boolean)key.startsWith(prefix));
            String sub = key.substring(prefix.length() + 1).trim();
            if (sub.isEmpty()) continue;
            String ns = ConfigElement.getComponents(sub)[0];
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)ns), (String)"Invalid sub-namespace for key: %s", (Object[])new Object[]{key});
            result.add(ns);
        }
        return result;
    }

    protected Map<String, Object> getSubset(ReadConfiguration config, ConfigNamespace umbrella, String ... umbrellaElements) {
        this.verifyElement(umbrella);
        String prefix = umbrella.isRoot() ? "" : ConfigElement.getPath((ConfigElement)umbrella, umbrellaElements);
        HashMap result = Maps.newHashMap();
        for (String key : config.getKeys(prefix)) {
            Preconditions.checkArgument((boolean)key.startsWith(prefix));
            int startIndex = umbrella.isRoot() ? prefix.length() : prefix.length() + 1;
            String sub = key.substring(startIndex).trim();
            if (sub.isEmpty()) continue;
            result.put(sub, config.get(key, Object.class));
        }
        return result;
    }

    protected static Configuration restrictTo(final Configuration config, final String ... fixedUmbrella) {
        Preconditions.checkArgument((fixedUmbrella != null && fixedUmbrella.length > 0 ? 1 : 0) != 0);
        return new Configuration(){

            private String[] concat(String ... others) {
                if (others == null || others.length == 0) {
                    return fixedUmbrella;
                }
                String[] join = new String[fixedUmbrella.length + others.length];
                System.arraycopy(fixedUmbrella, 0, join, 0, fixedUmbrella.length);
                System.arraycopy(others, 0, join, fixedUmbrella.length, others.length);
                return join;
            }

            @Override
            public boolean has(ConfigOption option, String ... umbrellaElements) {
                if (option.getNamespace().hasUmbrella()) {
                    return config.has(option, this.concat(umbrellaElements));
                }
                return config.has(option, new String[0]);
            }

            @Override
            public <O> O get(ConfigOption<O> option, String ... umbrellaElements) {
                if (option.getNamespace().hasUmbrella()) {
                    return config.get(option, this.concat(umbrellaElements));
                }
                return config.get(option, new String[0]);
            }

            @Override
            public Set<String> getContainedNamespaces(ConfigNamespace umbrella, String ... umbrellaElements) {
                return config.getContainedNamespaces(umbrella, this.concat(umbrellaElements));
            }

            @Override
            public Map<String, Object> getSubset(ConfigNamespace umbrella, String ... umbrellaElements) {
                return config.getSubset(umbrella, this.concat(umbrellaElements));
            }

            @Override
            public Configuration restrictTo(String ... umbrellaElements) {
                return config.restrictTo(this.concat(umbrellaElements));
            }
        };
    }

    public abstract void close();
}

