/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.utilities;

import com.strobel.annotations.NotNull;
import com.strobel.annotations.Nullable;
import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.CommonTypeReferences;
import com.strobel.assembler.metadata.DynamicCallSite;
import com.strobel.assembler.metadata.IMethodSignature;
import com.strobel.assembler.metadata.JvmType;
import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MetadataFilters;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.Comparer;
import com.strobel.core.Predicate;
import com.strobel.core.Predicates;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.languages.java.ast.ArrayCreationExpression;
import com.strobel.decompiler.languages.java.ast.ArrayInitializerExpression;
import com.strobel.decompiler.languages.java.ast.AssignmentExpression;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorType;
import com.strobel.decompiler.languages.java.ast.ConditionalExpression;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.LambdaExpression;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.MethodGroupExpression;
import com.strobel.decompiler.languages.java.ast.ParenthesizedExpression;
import com.strobel.decompiler.languages.java.ast.ReturnStatement;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.VariableDeclarationStatement;
import com.strobel.decompiler.languages.java.ast.VariableInitializer;
import com.strobel.decompiler.semantics.ResolveResult;
import com.strobel.functions.Function;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TypeUtilities {
    private static final String OBJECT_DESCRIPTOR = "java/lang/Object";
    private static final String STRING_DESCRIPTOR = "java/lang/String";
    private static final Map<JvmType, Integer> TYPE_TO_RANK_MAP;
    private static final Map<Class, TypeDefinition> BOXED_PRIMITIVES_BY_CLASS;
    private static final int BYTE_RANK = 1;
    private static final int SHORT_RANK = 2;
    private static final int CHAR_RANK = 3;
    private static final int INT_RANK = 4;
    private static final int LONG_RANK = 5;
    private static final int FLOAT_RANK = 6;
    private static final int DOUBLE_RANK = 7;
    private static final int BOOL_RANK = 10;
    private static final int STRING_RANK = 100;
    private static final int MAX_NUMERIC_RANK = 7;

    private static int getTypeRank(@NotNull TypeReference type) {
        TypeReference unboxedType = MetadataHelper.getUnderlyingPrimitiveTypeOrSelf(type);
        Integer rank = TYPE_TO_RANK_MAP.get((Object)unboxedType.getSimpleType());
        if (rank != null) {
            return rank;
        }
        if (StringUtilities.equals((String)type.getInternalName(), (String)STRING_DESCRIPTOR)) {
            return 100;
        }
        return Integer.MAX_VALUE;
    }

    public static boolean isPrimitive(@Nullable TypeReference type) {
        return type != null && type.isPrimitive();
    }

    public static boolean isPrimitiveOrWrapper(@Nullable TypeReference type) {
        if (type == null) {
            return false;
        }
        return MetadataHelper.getUnderlyingPrimitiveTypeOrSelf(type).isPrimitive();
    }

    public static boolean isBoolean(@Nullable TypeReference type) {
        if (type == null) {
            return false;
        }
        return MetadataHelper.getUnderlyingPrimitiveTypeOrSelf(type).getSimpleType() == JvmType.Boolean;
    }

    public static boolean isArithmetic(@Nullable TypeReference type) {
        if (type == null) {
            return false;
        }
        JvmType jvmType = MetadataHelper.getUnderlyingPrimitiveTypeOrSelf(type).getSimpleType();
        return jvmType.isNumeric() && jvmType != JvmType.Boolean;
    }

    public static boolean isBinaryOperatorApplicable(@NotNull BinaryOperatorType op, @NotNull AstType lType, @NotNull AstType rType, @Nullable TypeReference expectedResultType, boolean strict) {
        return TypeUtilities.isBinaryOperatorApplicable(op, ((AstType)VerifyArgument.notNull((Object)lType, (String)"lType")).toTypeReference(), ((AstType)VerifyArgument.notNull((Object)rType, (String)"rType")).toTypeReference(), expectedResultType, strict);
    }

    public static boolean isBinaryOperatorApplicable(@NotNull BinaryOperatorType op, @Nullable TypeReference lType, @Nullable TypeReference rType, @Nullable TypeReference expectedResultType, boolean strict) {
        if (lType == null || rType == null) {
            return true;
        }
        VerifyArgument.notNull((Object)((Object)op), (String)"op");
        int lRank = TypeUtilities.getTypeRank(lType);
        int rRank = TypeUtilities.getTypeRank(rType);
        TypeReference lUnboxed = MetadataHelper.getUnderlyingPrimitiveTypeOrSelf(lType);
        TypeReference rUnboxed = MetadataHelper.getUnderlyingPrimitiveTypeOrSelf(rType);
        int resultRank = 10;
        boolean isApplicable = false;
        switch (op) {
            case BITWISE_AND: 
            case BITWISE_OR: 
            case EXCLUSIVE_OR: {
                if (!lUnboxed.isPrimitive() || !rUnboxed.isPrimitive()) break;
                isApplicable = lRank <= 5 && rRank <= 5 || TypeUtilities.isBoolean(lUnboxed) || TypeUtilities.isBoolean(rUnboxed);
                resultRank = lRank <= 5 ? 4 : 10;
                break;
            }
            case LOGICAL_AND: 
            case LOGICAL_OR: {
                if (!lUnboxed.isPrimitive() || !rUnboxed.isPrimitive()) break;
                isApplicable = TypeUtilities.isBoolean(lType) && TypeUtilities.isBoolean(rType);
                break;
            }
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                if (!lUnboxed.isPrimitive() || !rUnboxed.isPrimitive()) break;
                isApplicable = lRank <= 7 && rRank <= 7;
                break;
            }
            case EQUALITY: 
            case INEQUALITY: {
                if (lUnboxed.isPrimitive() && rUnboxed.isPrimitive() && (lType.isPrimitive() || rType.isPrimitive())) {
                    isApplicable = lRank <= 7 && rRank <= 7 || lRank == 10 && rRank == 10;
                    break;
                }
                if (lType.isPrimitive()) {
                    return MetadataHelper.isConvertible(lType, rType);
                }
                if (rType.isPrimitive()) {
                    return MetadataHelper.isConvertible(rType, lType);
                }
                isApplicable = MetadataHelper.isConvertible(lType, rType) || MetadataHelper.isConvertible(rType, lType);
                break;
            }
            case ADD: {
                if (StringUtilities.equals((String)lType.getInternalName(), (String)STRING_DESCRIPTOR)) {
                    isApplicable = !rType.isVoid();
                    resultRank = 100;
                    break;
                }
                if (StringUtilities.equals((String)rType.getInternalName(), (String)STRING_DESCRIPTOR)) {
                    isApplicable = !lType.isVoid();
                    resultRank = 100;
                    break;
                }
                if (!lUnboxed.isPrimitive() || !rUnboxed.isPrimitive()) break;
                resultRank = Math.max(lRank, rRank);
                isApplicable = lRank <= 7 && rRank <= 7;
                break;
            }
            case SUBTRACT: 
            case MULTIPLY: 
            case DIVIDE: 
            case MODULUS: {
                if (!lUnboxed.isPrimitive() || !rUnboxed.isPrimitive()) break;
                resultRank = Math.max(lRank, rRank);
                isApplicable = lRank <= 7 && rRank <= 7;
                break;
            }
            case SHIFT_LEFT: 
            case SHIFT_RIGHT: 
            case UNSIGNED_SHIFT_RIGHT: {
                if (!lUnboxed.isPrimitive() || !rUnboxed.isPrimitive()) break;
                isApplicable = lRank <= 5 && rRank <= 5;
                resultRank = 4;
            }
        }
        if (isApplicable && strict) {
            if (resultRank > 7) {
                isApplicable = lRank == resultRank || StringUtilities.equals((String)lType.getInternalName(), (String)OBJECT_DESCRIPTOR);
            } else {
                boolean bl = isApplicable = lRank <= 7;
            }
        }
        if (isApplicable && expectedResultType != null) {
            int expectedResultRank = TypeUtilities.getTypeRank(MetadataHelper.getUnderlyingPrimitiveTypeOrSelf(expectedResultType));
            isApplicable = resultRank == expectedResultRank;
        }
        return isApplicable;
    }

    @Nullable
    public static AstNode skipParenthesesUp(AstNode e) {
        AstNode result = e;
        while (result instanceof ParenthesizedExpression) {
            result = result.getParent();
        }
        return result;
    }

    @Nullable
    public static AstNode skipParenthesesDown(AstNode e) {
        AstNode result = e;
        while (result instanceof ParenthesizedExpression) {
            result = ((ParenthesizedExpression)result).getExpression();
        }
        return result;
    }

    @Nullable
    public static Expression skipParenthesesDown(Expression e) {
        Expression result = e;
        while (result instanceof ParenthesizedExpression) {
            result = ((ParenthesizedExpression)result).getExpression();
        }
        return result;
    }

    private static boolean checkSameExpression(Expression template, Expression expression) {
        return Comparer.equals((Object)template, (Object)TypeUtilities.skipParenthesesDown(expression));
    }

    private static TypeReference getType(@NotNull Function<AstNode, ResolveResult> resolver, @NotNull AstNode node) {
        ResolveResult result = (ResolveResult)resolver.apply((Object)node);
        return result != null ? result.getType() : null;
    }

    @Nullable
    public static TypeReference getExpectedTypeByParent(Function<AstNode, ResolveResult> resolver, Expression expression) {
        VerifyArgument.notNull(resolver, (String)"resolver");
        VerifyArgument.notNull((Object)expression, (String)"expression");
        AstNode parent = TypeUtilities.skipParenthesesUp(expression.getParent());
        if (expression.getRole() == Roles.CONDITION) {
            return CommonTypeReferences.Boolean;
        }
        if (parent instanceof VariableInitializer) {
            if (TypeUtilities.checkSameExpression(expression, ((VariableInitializer)parent).getInitializer()) && parent.getParent() instanceof VariableDeclarationStatement) {
                return TypeUtilities.getType(resolver, parent.getParent());
            }
        } else {
            if (parent instanceof ArrayCreationExpression && expression.getRole() == ArrayCreationExpression.INITIALIZER_ROLE) {
                return TypeUtilities.getType(resolver, parent);
            }
            if (expression instanceof ArrayInitializerExpression && parent instanceof ArrayInitializerExpression) {
                TypeReference expectedArrayType = TypeUtilities.getExpectedTypeByParent(resolver, (Expression)parent);
                if (expectedArrayType != null && expectedArrayType.isArray()) {
                    return expectedArrayType.getElementType();
                }
            } else if (parent instanceof AssignmentExpression) {
                if (TypeUtilities.checkSameExpression(expression, ((AssignmentExpression)parent).getRight())) {
                    return TypeUtilities.getType(resolver, ((AssignmentExpression)parent).getLeft());
                }
            } else if (parent instanceof ReturnStatement) {
                LambdaExpression lambdaExpression = (LambdaExpression)CollectionUtilities.firstOrDefault(parent.getAncestors(LambdaExpression.class));
                if (lambdaExpression != null) {
                    DynamicCallSite callSite = lambdaExpression.getUserData(Keys.DYNAMIC_CALL_SITE);
                    if (callSite == null) {
                        return null;
                    }
                    MethodReference method = (MethodReference)callSite.getBootstrapArguments().get(0);
                    return method.getDeclaringType();
                }
                MethodDeclaration method = (MethodDeclaration)CollectionUtilities.firstOrDefault(parent.getAncestors(MethodDeclaration.class));
                if (method != null) {
                    return TypeUtilities.getType(resolver, method.getReturnType());
                }
            } else if (parent instanceof ConditionalExpression) {
                if (TypeUtilities.checkSameExpression(expression, ((ConditionalExpression)parent).getTrueExpression())) {
                    return TypeUtilities.getType(resolver, ((ConditionalExpression)parent).getFalseExpression());
                }
                if (TypeUtilities.checkSameExpression(expression, ((ConditionalExpression)parent).getFalseExpression())) {
                    return TypeUtilities.getType(resolver, ((ConditionalExpression)parent).getTrueExpression());
                }
            } else if (expression.getRole() == Roles.ARGUMENT && parent instanceof InvocationExpression) {
                MemberReference reference = parent.getUserData(Keys.MEMBER_REFERENCE);
                MethodReference method = reference instanceof MethodReference ? (MethodReference)reference : null;
                int position = CollectionUtilities.indexOf(((InvocationExpression)parent).getArguments(), (Object)expression);
                if (method != null && position >= 0 && method.getParameters().size() > 0) {
                    MethodDefinition resolved = method.resolve();
                    if (resolved != null && resolved.getParameters().size() == method.getParameters().size() && resolved.isVarArgs() && position >= resolved.getParameters().size() - 1) {
                        return method.getParameters().get(method.getParameters().size() - 1).getParameterType();
                    }
                    return method.getParameters().get(position).getParameterType();
                }
            }
        }
        return null;
    }

    public static IMethodSignature getLambdaSignature(MethodGroupExpression node) {
        return TypeUtilities.getLambdaSignatureCore(node);
    }

    public static IMethodSignature getLambdaSignature(LambdaExpression node) {
        return TypeUtilities.getLambdaSignatureCore(node);
    }

    public static boolean isValidPrimitiveLiteralAssignment(TypeReference targetType, Object value) {
        JvmType valueJvmType;
        Number n;
        VerifyArgument.notNull((Object)targetType, (String)"targetType");
        if (targetType.getSimpleType() == JvmType.Boolean) {
            return value instanceof Boolean;
        }
        if (!targetType.isPrimitive() || !(value instanceof Number) && !(value instanceof Character)) {
            return false;
        }
        Number number = n = value instanceof Character ? (Number)Integer.valueOf(((Character)value).charValue()) : (Number)((Number)value);
        if (n instanceof Float || n instanceof Double) {
            if (targetType.getSimpleType() == JvmType.Float) {
                return n.doubleValue() == (double)((float)n.doubleValue());
            }
            return targetType.getSimpleType() == JvmType.Double;
        }
        TypeDefinition valueType = BOXED_PRIMITIVES_BY_CLASS.get(n.getClass());
        JvmType jvmType = valueJvmType = valueType != null ? valueType.getSimpleType() : JvmType.Void;
        if (n instanceof Long) {
            switch (targetType.getSimpleType()) {
                case Long: 
                case Float: 
                case Double: {
                    return true;
                }
            }
        }
        switch (targetType.getSimpleType()) {
            case Byte: {
                return valueJvmType.isSubWordOrInt32() && valueJvmType != JvmType.Boolean && n.intValue() >= -128 && n.intValue() <= 127;
            }
            case Character: {
                return valueJvmType.isSubWordOrInt32() && valueJvmType != JvmType.Boolean && n.intValue() >= 0 && n.intValue() <= 65535;
            }
            case Short: {
                return valueJvmType.isSubWordOrInt32() && valueJvmType != JvmType.Boolean && n.intValue() >= Short.MIN_VALUE && n.intValue() <= Short.MAX_VALUE;
            }
            case Integer: {
                return valueJvmType.isSubWordOrInt32() && valueJvmType != JvmType.Boolean && n.longValue() >= Integer.MIN_VALUE && n.longValue() <= Integer.MAX_VALUE;
            }
            case Long: {
                return valueJvmType.isIntegral() && valueJvmType != JvmType.Boolean;
            }
            case Float: 
            case Double: {
                return true;
            }
        }
        return false;
    }

    private static IMethodSignature getLambdaSignatureCore(Expression node) {
        VerifyArgument.notNull((Object)node, (String)"node");
        TypeReference lambdaType = node.getUserData(Keys.TYPE_REFERENCE);
        DynamicCallSite callSite = node.getUserData(Keys.DYNAMIC_CALL_SITE);
        if (lambdaType == null) {
            if (callSite == null) {
                return null;
            }
            return (IMethodSignature)callSite.getBootstrapArguments().get(2);
        }
        TypeDefinition resolvedType = lambdaType.resolve();
        if (resolvedType == null) {
            if (callSite == null) {
                return null;
            }
            return (IMethodSignature)callSite.getBootstrapArguments().get(2);
        }
        MemberReference functionMethod = null;
        List<MethodReference> methods = MetadataHelper.findMethods(resolvedType, (Predicate<? super MethodReference>)(callSite != null ? MetadataFilters.matchName(callSite.getMethodName()) : Predicates.alwaysTrue()));
        for (MethodReference m : methods) {
            MethodDefinition r = m.resolve();
            if (r == null || !r.isAbstract() || r.isStatic() || r.isDefault()) continue;
            functionMethod = r;
            break;
        }
        if (functionMethod != null) {
            TypeReference effectiveType;
            TypeReference asMemberOf = MetadataHelper.asSuper(functionMethod.getDeclaringType(), lambdaType);
            TypeReference typeReference = effectiveType = asMemberOf != null ? asMemberOf : lambdaType;
            if (MetadataHelper.isRawType(effectiveType)) {
                return MetadataHelper.erase((MethodReference)functionMethod);
            }
            functionMethod = MetadataHelper.asMemberOf((MethodReference)functionMethod, effectiveType);
        }
        return functionMethod;
    }

    static {
        EnumMap<JvmType, Integer> rankMap = new EnumMap<JvmType, Integer>(JvmType.class);
        HashMap<Class<Void>, TypeDefinition> boxedPrimitivesByClass = new HashMap<Class<Void>, TypeDefinition>();
        rankMap.put(JvmType.Byte, 1);
        rankMap.put(JvmType.Short, 2);
        rankMap.put(JvmType.Character, 3);
        rankMap.put(JvmType.Integer, 4);
        rankMap.put(JvmType.Long, 5);
        rankMap.put(JvmType.Float, 6);
        rankMap.put(JvmType.Double, 7);
        rankMap.put(JvmType.Boolean, 10);
        boxedPrimitivesByClass.put(Byte.class, BuiltinTypes.Byte);
        boxedPrimitivesByClass.put(Short.class, BuiltinTypes.Short);
        boxedPrimitivesByClass.put(Character.class, BuiltinTypes.Character);
        boxedPrimitivesByClass.put(Integer.class, BuiltinTypes.Integer);
        boxedPrimitivesByClass.put(Long.class, BuiltinTypes.Long);
        boxedPrimitivesByClass.put(Float.class, BuiltinTypes.Float);
        boxedPrimitivesByClass.put(Double.class, BuiltinTypes.Double);
        boxedPrimitivesByClass.put(Boolean.class, BuiltinTypes.Boolean);
        boxedPrimitivesByClass.put(Void.class, BuiltinTypes.Void);
        TYPE_TO_RANK_MAP = Collections.unmodifiableMap(rankMap);
        BOXED_PRIMITIVES_BY_CLASS = Collections.unmodifiableMap(boxedPrimitivesByClass);
    }
}

