/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.metadata;

import java.util.ArrayList;
import java.util.List;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.windup.config.furnace.FurnaceHolder;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.TechnologyReference;
import org.jboss.windup.config.metadata.TechnologyReferenceAliasTranslatorLoader;

public class TechnologyReferenceAliasTranslator {
    private final TechnologyReference original;
    private final TechnologyReference target;

    public TechnologyReferenceAliasTranslator(TechnologyReference original, TechnologyReference target) {
        this.original = original;
        this.target = target;
    }

    public static List<TechnologyReferenceAliasTranslator> getAliasTranslators(RuleLoaderContext ruleLoaderContext) {
        ArrayList<TechnologyReferenceAliasTranslator> transformerList = new ArrayList<TechnologyReferenceAliasTranslator>();
        Imported loaders = FurnaceHolder.getFurnace().getAddonRegistry(new AddonRepository[0]).getServices(TechnologyReferenceAliasTranslatorLoader.class);
        loaders.forEach(loader -> transformerList.addAll(loader.loadTranslators(ruleLoaderContext)));
        return transformerList;
    }

    public TechnologyReference getOriginalTechnology() {
        return this.original;
    }

    public TechnologyReference getTargetTechnology() {
        return this.target;
    }

    public TechnologyReference translate(TechnologyReference technology) {
        return this.original.matches(technology) ? this.target : technology;
    }

    public TechnologyReference translate(String technologyIdAndVersion) {
        TechnologyReference technology = TechnologyReference.parseFromIDAndVersion(technologyIdAndVersion);
        return this.original.matches(technology) ? this.target : technology;
    }
}

