/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.projecttraversal;

import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.windup.config.AbstractRuleLifecycleListener;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.graph.traversal.ProjectModelTraversal;

public class ProjectTraversalCache
extends AbstractRuleLifecycleListener {
    private static final Map<ProjectModel, SoftReference<Set<ProjectModel>>> moduleToApplicationCache = new ConcurrentHashMap<ProjectModel, SoftReference<Set<ProjectModel>>>();
    private static final Map<ProjectModel, SoftReference<Set<ProjectModel>>> applicationToProjectCache = new ConcurrentHashMap<ProjectModel, SoftReference<Set<ProjectModel>>>();

    @Override
    public void beforeExecution(GraphRewrite event) {
        moduleToApplicationCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<ProjectModel> getApplicationsForProject(GraphContext context, ProjectModel project) {
        Set<ProjectModel> results = ProjectTraversalCache.getFromCache(project);
        if (results != null) {
            return results;
        }
        results = new HashSet<ProjectModel>();
        WindupConfigurationModel configurationModel = WindupConfigurationService.getConfigurationModel((GraphContext)context);
        for (FileModel inputFile : configurationModel.getInputPaths()) {
            ProjectModel application = inputFile.getProjectModel();
            Map<ProjectModel, SoftReference<Set<ProjectModel>>> map = applicationToProjectCache;
            synchronized (map) {
                SoftReference<Set<ProjectModel>> projectsInApplicationReference = applicationToProjectCache.get(application);
                Set projectsInApplication = null;
                if (projectsInApplicationReference != null) {
                    projectsInApplication = projectsInApplicationReference.get();
                }
                if (projectsInApplication == null) {
                    ProjectModelTraversal traversal = new ProjectModelTraversal(application);
                    projectsInApplication = traversal.getAllProjects(true);
                    applicationToProjectCache.put(application, new SoftReference<Set>(projectsInApplication));
                }
                if (projectsInApplication.contains(project)) {
                    results.add(application);
                }
            }
        }
        if (results.isEmpty()) {
            results.add(project);
        }
        ProjectTraversalCache.putInCache(project, results);
        return results;
    }

    public static void clear() {
        moduleToApplicationCache.clear();
        applicationToProjectCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<ProjectModel> getFromCache(ProjectModel project) {
        if (project == null) {
            return null;
        }
        Map<ProjectModel, SoftReference<Set<ProjectModel>>> map = moduleToApplicationCache;
        synchronized (map) {
            SoftReference<Set<ProjectModel>> referenceProjectsSet = moduleToApplicationCache.get(project);
            return referenceProjectsSet == null ? null : referenceProjectsSet.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putInCache(ProjectModel project, Set<ProjectModel> projects) {
        if (project == null) {
            return;
        }
        Map<ProjectModel, SoftReference<Set<ProjectModel>>> map = moduleToApplicationCache;
        synchronized (map) {
            SoftReference<Set<ProjectModel>> referenceProjectsSet = new SoftReference<Set<ProjectModel>>(projects);
            moduleToApplicationCache.put(project, referenceProjectsSet);
        }
    }
}

