/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.metadata;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class Label {
    private final String id;
    private final String name;
    private final String description;
    private final Set<String> supported = new HashSet<String>();
    private final Set<String> unsuitable = new HashSet<String>();
    private final Set<String> neutral = new HashSet<String>();
    private String labelString;

    public Label(String id, String name) {
        this.id = id;
        this.name = name;
        this.description = null;
    }

    public Label(String id, String name, String description) {
        this.id = id;
        this.name = name;
        this.description = description;
    }

    public Label(String id, String name, String description, String labelString) {
        this(id, name, description);
        this.labelString = labelString;
    }

    public void addSupportedTags(Collection<String> tags) {
        this.supported.addAll(tags);
    }

    public void addUnsuitableTags(Collection<String> tags) {
        this.unsuitable.addAll(tags);
    }

    public void addNeutralTags(Collection<String> tags) {
        this.neutral.addAll(tags);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<String> getSupported() {
        return this.supported;
    }

    public Set<String> getUnsuitable() {
        return this.unsuitable;
    }

    public Set<String> getNeutral() {
        return this.neutral;
    }

    public String getId() {
        return this.id;
    }

    public String getLabelString() {
        return this.labelString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Label label = (Label)o;
        return this.name.equals(label.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

