/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.query;

import java.util.function.BiPredicate;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.attribute.Text;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.query.QueryGremlinCriterion;
import org.jboss.windup.config.query.QueryPropertyComparisonType;

class QueryPropertyCriterion
implements QueryGremlinCriterion {
    private final String propertyName;
    private final QueryPropertyComparisonType searchType;
    private final Object searchValue;

    public QueryPropertyCriterion(String propertyName, QueryPropertyComparisonType searchType, Object searchValue) {
        this.propertyName = propertyName;
        this.searchType = searchType;
        this.searchValue = searchValue;
    }

    @Override
    public void query(GraphRewrite event, GraphTraversal<?, Vertex> pipeline) {
        switch (this.searchType) {
            case EQUALS: {
                pipeline.has(this.propertyName, this.searchValue);
                break;
            }
            case NOT_EQUALS: {
                pipeline.has(this.propertyName, P.neq((Object)this.searchValue));
                break;
            }
            case CONTAINS_TOKEN: {
                pipeline.has(this.propertyName, Text.textContains((Object)this.searchValue));
                break;
            }
            case CONTAINS_ANY_TOKEN: {
                pipeline.has(this.propertyName, new P((BiPredicate)new MultipleValueTitanPredicate(), this.searchValue));
                break;
            }
            case REGEX: {
                pipeline.has(this.propertyName, Text.textRegex((Object)this.searchValue));
                break;
            }
            case DEFINED: {
                pipeline.has(this.propertyName);
                break;
            }
            case NOT_DEFINED: {
                pipeline.hasNot(this.propertyName);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized property query type: " + this.searchType);
            }
        }
    }

    public String toString() {
        return ".has(" + this.propertyName + "," + this.searchType + "," + this.searchValue + ")";
    }

    private static final class MultipleValueTitanPredicate
    implements BiPredicate {
        private MultipleValueTitanPredicate() {
        }

        public boolean test(Object first, Object second) {
            if (first == null) {
                return false;
            }
            if (second instanceof Iterable) {
                boolean found = false;
                for (Object element : (Iterable)second) {
                    if (element instanceof Enum && ((Enum)element).name().equals(first)) {
                        found = true;
                        break;
                    }
                    if (!first.equals(element)) continue;
                    found = true;
                    break;
                }
                return found;
            }
            return false;
        }
    }
}

