/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.LabelProvider;
import org.jboss.windup.config.metadata.Label;

public class LabelProviderRegistry {
    private final List<LabelProvider> providers = new ArrayList<LabelProvider>();
    private final IdentityHashMap<LabelProvider, List<Label>> providersToLabels = new IdentityHashMap();

    public static LabelProviderRegistry instance(GraphRewrite event) {
        return (LabelProviderRegistry)event.getRewriteContext().get(LabelProviderRegistry.class);
    }

    public void setProviders(List<LabelProvider> providers) {
        this.providers.clear();
        this.providers.addAll(providers);
    }

    public List<LabelProvider> getProviders() {
        return Collections.unmodifiableList(this.providers);
    }

    public void setLabels(LabelProvider provider, List<Label> labels) {
        this.providersToLabels.put(provider, labels);
    }

    public List<Label> getLabels(LabelProvider provider) {
        List<Label> labels = this.providersToLabels.get(provider);
        if (labels == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(labels);
    }
}

