/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.tags;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class Tag {
    private final String name;
    private final Set<Tag> containedTags = new HashSet<Tag>();
    private final Set<Tag> parentTags = new HashSet<Tag>();
    private boolean isPrime = false;
    private boolean isPseudo = false;
    private boolean isRoot = false;
    private String color = null;
    private String title = null;
    private Map<String, String> traits = null;

    Tag(String name) {
        this.name = Tag.normalizeName(name);
    }

    public static String normalizeName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Tag name must not be null.");
        }
        return name.toLowerCase().replace(' ', '-');
    }

    public String getName() {
        return this.name;
    }

    public Set<Tag> getContainedTags() {
        return Collections.unmodifiableSet(this.containedTags);
    }

    public Set<Tag> getParentTags() {
        return Collections.unmodifiableSet(this.parentTags);
    }

    public void addContainedTag(Tag tag) {
        this.containedTags.add(tag);
        tag.parentTags.add(this);
    }

    public void addContainingTag(Tag tag) {
        this.parentTags.add(tag);
        tag.containedTags.add(this);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tag other = (Tag)obj;
        return Objects.equals(this.name, other.name);
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setIsRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }

    public boolean isPrime() {
        return this.isPrime;
    }

    public void setIsPrime(boolean isPrime) {
        this.isPrime = isPrime;
    }

    public boolean isPseudo() {
        return this.isPseudo;
    }

    public void setPseudo(boolean isPseudo) {
        this.isPseudo = isPseudo;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitleOrName() {
        return this.title != null ? this.title : this.name;
    }

    public Map<String, String> getTraits() {
        return this.traits;
    }

    public Map<String, String> getOrCreateTraits() {
        return this.traits != null ? this.traits : (this.traits = new HashMap<String, String>());
    }

    public String toString() {
        return "#" + this.name + "(" + (this.containedTags == null ? 45 : this.containedTags.size()) + ')';
    }
}

