/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.operation;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.Variables;
import org.jboss.windup.config.condition.GraphCondition;
import org.jboss.windup.config.exception.IllegalTypeArgumentException;
import org.jboss.windup.config.operation.Commit;
import org.jboss.windup.config.operation.IterationProgress;
import org.jboss.windup.config.operation.OperationUtil;
import org.jboss.windup.config.operation.iteration.IterationBuilderComplete;
import org.jboss.windup.config.operation.iteration.IterationBuilderOtherwise;
import org.jboss.windup.config.operation.iteration.IterationBuilderOver;
import org.jboss.windup.config.operation.iteration.IterationBuilderPerform;
import org.jboss.windup.config.operation.iteration.IterationBuilderVar;
import org.jboss.windup.config.operation.iteration.IterationBuilderWhen;
import org.jboss.windup.config.operation.iteration.IterationPayloadManager;
import org.jboss.windup.config.operation.iteration.NamedFramesSelector;
import org.jboss.windup.config.operation.iteration.NamedIterationPayloadManager;
import org.jboss.windup.config.operation.iteration.TopLayerSingletonFramesSelector;
import org.jboss.windup.config.operation.iteration.TypedFramesSelector;
import org.jboss.windup.config.operation.iteration.TypedNamedFramesSelector;
import org.jboss.windup.config.operation.iteration.TypedNamedIterationPayloadManager;
import org.jboss.windup.config.selectors.FramesSelector;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.util.exception.WindupException;
import org.jboss.windup.util.exception.WindupStopException;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.config.And;
import org.ocpsoft.rewrite.config.CompositeCondition;
import org.ocpsoft.rewrite.config.CompositeOperation;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.DefaultOperationBuilder;
import org.ocpsoft.rewrite.config.NoOp;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.config.OperationBuilder;
import org.ocpsoft.rewrite.config.Perform;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;

public class Iteration
extends DefaultOperationBuilder
implements IterationBuilderVar,
IterationBuilderOver,
IterationBuilderWhen,
IterationBuilderPerform,
IterationBuilderOtherwise,
IterationBuilderComplete,
CompositeOperation,
Parameterized {
    private static final String VAR_INSTANCE_STRING = "_instance";
    public static final String DEFAULT_VARIABLE_LIST_STRING = "default";
    public static final String DEFAULT_SINGLE_VARIABLE_STRING = Iteration.singleVariableIterationName("default");
    private Condition condition;
    private Operation operationPerform;
    private Operation operationOtherwise;
    private IterationPayloadManager payloadManager;
    private final FramesSelector selectionManager;

    public static String singleVariableIterationName(String selectionName) {
        return selectionName + VAR_INSTANCE_STRING;
    }

    private Iteration(FramesSelector selectionManager) {
        Assert.notNull((Object)selectionManager, (String)"Selection manager must not be null.");
        this.selectionManager = selectionManager;
    }

    public static IterationBuilderOver over(Class<? extends WindupVertexFrame> sourceType, String source) {
        Iteration iterationImpl = new Iteration(new TypedNamedFramesSelector(sourceType, source));
        iterationImpl.setPayloadManager(new TypedNamedIterationPayloadManager(sourceType, Iteration.singleVariableIterationName(source)));
        return iterationImpl;
    }

    public static IterationBuilderOver over(String source) {
        Iteration iterationImpl = new Iteration(new NamedFramesSelector(source));
        iterationImpl.setPayloadManager(new NamedIterationPayloadManager(Iteration.singleVariableIterationName(source)));
        return iterationImpl;
    }

    public static IterationBuilderOver over(Class<? extends WindupVertexFrame> sourceType) {
        Iteration iterationImpl = new Iteration(new TypedFramesSelector(sourceType));
        iterationImpl.setPayloadManager(new TypedNamedIterationPayloadManager(sourceType, DEFAULT_SINGLE_VARIABLE_STRING));
        return iterationImpl;
    }

    public static IterationBuilderOver over() {
        Iteration iterationImpl = new Iteration(new TopLayerSingletonFramesSelector());
        iterationImpl.setPayloadManager(new NamedIterationPayloadManager(DEFAULT_SINGLE_VARIABLE_STRING));
        return iterationImpl;
    }

    public Set<String> getRequiredParameterNames() {
        return this.getRequiredParameterNames(this.condition);
    }

    public void setParameterStore(ParameterStore store) {
        this.setParameterStore(store, this.condition);
    }

    private Set<String> getRequiredParameterNames(Condition condition) {
        HashSet<String> result = new HashSet<String>();
        if (condition instanceof Parameterized) {
            result.addAll(((Parameterized)condition).getRequiredParameterNames());
        }
        if (condition instanceof CompositeCondition) {
            ((CompositeCondition)condition).getConditions().forEach(innerCondition -> result.addAll(this.getRequiredParameterNames((Condition)innerCondition)));
        }
        return result;
    }

    private void setParameterStore(ParameterStore store, Condition condition) {
        if (condition instanceof Parameterized) {
            ((Parameterized)condition).setParameterStore(store);
        }
        if (condition instanceof CompositeCondition) {
            ((CompositeCondition)condition).getConditions().forEach(innerCondition -> this.setParameterStore(store, (Condition)innerCondition));
        }
    }

    @Override
    public IterationBuilderVar as(Class<? extends WindupVertexFrame> varType, String var) {
        this.setPayloadManager(new TypedNamedIterationPayloadManager(varType, var));
        return this;
    }

    @Override
    public IterationBuilderVar as(String var) {
        this.setPayloadManager(new NamedIterationPayloadManager(var));
        return this;
    }

    public IterationBuilderWhen all(Condition ... condition) {
        this.condition = And.all((Condition[])condition);
        return this;
    }

    @Override
    public IterationBuilderWhen when(Condition condition) {
        this.condition = condition;
        return this;
    }

    @Override
    public IterationBuilderPerform perform(Operation operation) {
        this.operationPerform = operation;
        return this;
    }

    @Override
    public IterationBuilderPerform perform(Operation ... operations) {
        this.operationPerform = Perform.all((Operation[])operations);
        return this;
    }

    @Override
    public IterationBuilderOtherwise otherwise(Operation operation) {
        this.operationOtherwise = operation;
        return this;
    }

    @Override
    public IterationBuilderComplete endIteration() {
        return this;
    }

    public void perform(Rewrite event, EvaluationContext context) {
        this.perform((GraphRewrite)event, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void perform(GraphRewrite event, EvaluationContext context) {
        int frameCount;
        Variables variables = Variables.instance(event);
        Iterable<? extends WindupVertexFrame> frames = this.getSelectionManager().getFrames(event, context);
        boolean hasCommitOperation = OperationUtil.hasCommitOperation(this.operationPerform) || OperationUtil.hasCommitOperation(this.operationOtherwise);
        boolean hasIterationOperation = OperationUtil.hasIterationProgress(this.operationPerform) || OperationUtil.hasIterationProgress(this.operationOtherwise);
        Object commit = new NoOp();
        Object iterationProgressOperation = new NoOp();
        if (!(hasCommitOperation && hasIterationOperation || (frameCount = Iterables.size(frames)) <= 100)) {
            if (!hasCommitOperation) {
                commit = Commit.every(1000);
            }
            if (!hasIterationOperation) {
                iterationProgressOperation = IterationProgress.monitoring("Rule Progress", 500);
            }
        }
        OperationBuilder commitAndProgress = commit.and((Operation)iterationProgressOperation);
        event.getRewriteContext().put((Object)DEFAULT_VARIABLE_LIST_STRING, frames);
        try {
            for (WindupVertexFrame windupVertexFrame : frames) {
                try {
                    variables.push();
                    this.getPayloadManager().setCurrentPayload(variables, windupVertexFrame);
                    boolean conditionResult = true;
                    if (this.condition != null) {
                        String payloadVariableName = Iteration.getPayloadVariableName(event, context);
                        this.passInputVariableNameToConditionTree(this.condition, payloadVariableName);
                        conditionResult = this.condition.evaluate((Rewrite)event, context);
                        variables.push();
                        this.getPayloadManager().setCurrentPayload(variables, windupVertexFrame);
                    }
                    if (conditionResult) {
                        if (this.operationPerform != null) {
                            this.operationPerform.perform((Rewrite)event, context);
                        }
                    } else if (this.condition != null && this.operationOtherwise != null) {
                        this.operationOtherwise.perform((Rewrite)event, context);
                    }
                    commitAndProgress.perform((Rewrite)event, context);
                    this.getPayloadManager().removeCurrentPayload(variables);
                    variables.pop();
                    if (this.condition == null) continue;
                    variables.pop();
                }
                catch (WindupStopException ex) {
                    throw new WindupStopException("MTA stop requested in " + this.toString(), (Exception)((Object)ex));
                }
                catch (Exception e) {
                    throw new WindupException("Failed when iterating " + windupVertexFrame.toPrettyString() + ", due to: " + e.getMessage(), (Throwable)e);
                    return;
                }
            }
        }
        finally {
            event.getRewriteContext().put((Object)DEFAULT_VARIABLE_LIST_STRING, null);
        }
    }

    private void passInputVariableNameToConditionTree(Condition condition, String payloadVariableName) throws IllegalStateException {
        if (condition instanceof GraphCondition) {
            ((GraphCondition)condition).setInputVariablesName(payloadVariableName);
        }
        if (condition instanceof CompositeCondition) {
            CompositeCondition composite = (CompositeCondition)condition;
            for (Condition childCondition : composite.getConditions()) {
                this.passInputVariableNameToConditionTree(childCondition, payloadVariableName);
            }
        }
    }

    public List<Operation> getOperations() {
        return Arrays.asList(this.operationPerform, this.operationOtherwise);
    }

    public static String getPayloadVariableName(GraphRewrite event, EvaluationContext ctx) throws IllegalStateException {
        Variables variables = Variables.instance(event);
        Map<String, Iterable<? extends WindupVertexFrame>> topLayer = variables.peek();
        if (topLayer.keySet().size() != 1) {
            throw new IllegalStateException("Cannot determine Iteration payload variable name because the top layer of " + Variables.class.getSimpleName() + " stack contains " + topLayer.keySet().size() + " variables: " + topLayer.keySet());
        }
        String name = topLayer.keySet().iterator().next();
        return name;
    }

    public static void setCurrentPayload(Variables stack, String name, WindupVertexFrame frame) throws IllegalArgumentException {
        Map<String, Iterable<? extends WindupVertexFrame>> vars = stack.peek();
        Iterable<? extends WindupVertexFrame> existingValue = vars.get(name);
        if (existingValue != null && !(existingValue instanceof IterationPayload)) {
            throw new IllegalArgumentException("Variable \"" + name + "\" has already been assigned and cannot be used as an " + Iteration.class.getSimpleName() + " variable.");
        }
        vars.put(name, new IterationPayload<WindupVertexFrame>(frame));
    }

    public static <FRAMETYPE extends WindupVertexFrame> FRAMETYPE getCurrentPayload(Variables stack, String name) throws IllegalStateException, IllegalArgumentException {
        Map<String, Iterable<? extends WindupVertexFrame>> vars = stack.peek();
        Iterable<? extends WindupVertexFrame> existingValue = vars.get(name);
        if (existingValue != null && !(existingValue instanceof IterationPayload)) {
            throw new IllegalArgumentException("Variable \"" + name + "\" is not an " + Iteration.class.getSimpleName() + " variable.");
        }
        Object object = stack.findSingletonVariable(name);
        return (FRAMETYPE)((WindupVertexFrame)object);
    }

    public static <FRAMETYPE extends WindupVertexFrame> FRAMETYPE getCurrentPayload(Variables stack, Class<FRAMETYPE> type, String name) throws IllegalStateException, IllegalArgumentException {
        Map<String, Iterable<? extends WindupVertexFrame>> vars = stack.peek();
        Iterable<? extends WindupVertexFrame> existingValue = vars.get(name);
        if (existingValue != null && !(existingValue instanceof IterationPayload)) {
            throw new IllegalArgumentException("Variable \"" + name + "\" is not an " + Iteration.class.getSimpleName() + " variable.");
        }
        FRAMETYPE object = stack.findSingletonVariable(type, name);
        return (FRAMETYPE)((WindupVertexFrame)object);
    }

    public static <FRAMETYPE extends WindupVertexFrame> FRAMETYPE removeCurrentPayload(Variables stack, Class<FRAMETYPE> type, String name) throws IllegalStateException, IllegalTypeArgumentException {
        FRAMETYPE payload = Iteration.getCurrentPayload(stack, type, name);
        Map<String, Iterable<? extends WindupVertexFrame>> vars = stack.peek();
        vars.remove(name);
        return payload;
    }

    public static <FRAMETYPE extends WindupVertexFrame> FRAMETYPE removeCurrentPayload(Variables stack, String name) throws IllegalStateException, IllegalTypeArgumentException {
        FRAMETYPE payload = Iteration.getCurrentPayload(stack, name);
        Map<String, Iterable<? extends WindupVertexFrame>> vars = stack.peek();
        vars.remove(name);
        return payload;
    }

    public void setPayloadManager(IterationPayloadManager payloadManager) {
        Assert.notNull((Object)payloadManager, (String)"Payload manager must not be null.");
        this.payloadManager = payloadManager;
    }

    public FramesSelector getSelectionManager() {
        return this.selectionManager;
    }

    public IterationPayloadManager getPayloadManager() {
        return this.payloadManager;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Iteration.over(?)");
        if (!this.getPayloadManager().getPayLoadName().equals(DEFAULT_SINGLE_VARIABLE_STRING)) {
            builder.append(".as(").append(this.getPayloadManager().getPayLoadName()).append(")");
        }
        if (this.condition != null) {
            builder.append(".when(").append(this.condition).append(")");
        }
        if (this.operationPerform != null) {
            builder.append(".perform(").append(this.operationPerform).append(")");
        }
        if (this.operationOtherwise != null) {
            builder.append(".otherwise(").append(this.operationOtherwise).append(")");
        }
        return builder.toString();
    }

    private static class IterationPayload<T>
    extends HashSet<T> {
        private static final long serialVersionUID = 7725055142596456025L;

        public IterationPayload(T element) {
            super(1);
            super.add(element);
        }

        @Override
        public boolean add(T e) {
            throw new UnsupportedOperationException("Iteration payloads are not modifiable.");
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("Iteration payloads are not modifiable.");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Iteration payloads are not modifiable.");
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException("Iteration payloads are not modifiable.");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException("Iteration payloads are not modifiable.");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException("Iteration payloads are not modifiable.");
        }
    }
}

