/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.phase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.proxy.Proxies;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.windup.config.furnace.FurnaceHolder;
import org.jboss.windup.config.phase.RulePhase;

public class RulePhaseFinder {
    private Map<String, Class<? extends RulePhase>> cachedPhases;

    private String classNameToMapKey(String className) {
        return className.toUpperCase();
    }

    public Class<? extends RulePhase> findPhase(String phaseStr) {
        if (phaseStr == null) {
            return null;
        }
        if (this.cachedPhases == null) {
            this.cachedPhases = this.loadPhases();
        }
        return this.cachedPhases.get(this.classNameToMapKey(phaseStr));
    }

    private Map<String, Class<? extends RulePhase>> loadPhases() {
        HashMap phases = new HashMap();
        Furnace furnace = FurnaceHolder.getFurnace();
        for (RulePhase phase : furnace.getAddonRegistry(new AddonRepository[0]).getServices(RulePhase.class)) {
            Class<?> unwrappedClass = Proxies.unwrap((Object)phase).getClass();
            String simpleName = unwrappedClass.getSimpleName();
            phases.put(this.classNameToMapKey(simpleName), unwrappedClass);
        }
        return Collections.unmodifiableMap(phases);
    }

    public List<Class<? extends RulePhase>> getAvailablePhases() {
        ArrayList<Class<? extends RulePhase>> phases = new ArrayList<Class<? extends RulePhase>>(this.cachedPhases.values());
        phases.sort(new Comparator(){

            public int compare(Object phaseClass1, Object phaseClass2) {
                if (phaseClass1 == null || !(phaseClass1 instanceof Class)) {
                    return -1;
                }
                if (phaseClass2 == null || !(phaseClass2 instanceof Class)) {
                    return 1;
                }
                String name1 = ((Class)phaseClass1).getSimpleName();
                String name2 = ((Class)phaseClass2).getSimpleName();
                return name1.compareToIgnoreCase(name2);
            }
        });
        return phases;
    }
}

