/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.tags;

import java.util.Map;
import java.util.Stack;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.tags.Tag;
import org.jboss.windup.config.tags.TagService;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TagsSaxHandler
extends DefaultHandler {
    private static final Logger LOG = Logger.getLogger(TagsSaxHandler.class.getName());
    private final TagService tagService;
    private final Stack<Tag> stack = new Stack();

    public TagsSaxHandler(TagService tagsService) {
        this.tagService = tagsService;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("tag".equals(qName)) {
            String[] containedBy;
            boolean isRef;
            String tagName = attributes.getValue("name");
            String tagRef = attributes.getValue("ref");
            boolean bl = isRef = tagRef != null && !"".equals(tagRef);
            if (isRef) {
                tagName = tagRef;
            }
            Tag tag = this.tagService.getOrCreateTag(tagName, tagRef != null);
            LOG.info("/// Reading tag " + tag);
            if (!isRef) {
                String color;
                String title;
                if ("true".equals(attributes.getValue("prime"))) {
                    tag.setIsPrime(true);
                }
                if ("true".equals(attributes.getValue("pseudo"))) {
                    tag.setPseudo(true);
                }
                if ((title = attributes.getValue("title")) != null) {
                    if (tag.getTitle() != null) {
                        LOG.warning("Redefining tag title to '" + title + "', was: " + tag.toString());
                    }
                    tag.setTitle(title);
                }
                if ((color = attributes.getValue("color")) != null) {
                    if (tag.getColor() != null) {
                        LOG.warning("Redefining tag color to '" + color + "', was: " + tag.getColor());
                    }
                    if (color.matches("(#\\p{XDigit}{6})|[a-z]+")) {
                        tag.setColor(color);
                    } else {
                        LOG.fine("Invalid color, not matching #\\p{XDigit}{6}: " + color);
                    }
                }
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String attrQName = attributes.getQName(i);
                    if ("prime".equals(attrQName) || "pseudo".equals(attrQName) || "name".equals(attrQName) || "ref".equals(attrQName) || "title".equals(attrQName) || "color".equals(attrQName) || "parents".equals(attrQName)) continue;
                    Map<String, String> traits = tag.getOrCreateTraits();
                    traits.put(attrQName, attributes.getValue(i));
                }
            }
            if (!this.stack.empty()) {
                this.stack.peek().addContainedTag(tag);
            } else {
                tag.setIsRoot(true);
            }
            this.stack.push(tag);
            for (String containingTagName : containedBy = StringUtils.split((String)StringUtils.defaultString((String)attributes.getValue("parents")), (String)" ,")) {
                Tag containingTag = this.tagService.getOrCreateTag(containingTagName, true);
                tag.addContainingTag(containingTag);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("tag".equals(qName)) {
            this.stack.pop();
        }
    }
}

