/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.tags;

import java.util.Stack;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.tags.Tag;
import org.jboss.windup.config.tags.TagService;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TagsSaxHandler
extends DefaultHandler {
    private static final Logger log = Logger.getLogger(TagsSaxHandler.class.getName());
    private final TagService tagService;
    private final Stack<Tag> stack = new Stack();

    public TagsSaxHandler(TagService tagsService) {
        this.tagService = tagsService;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("tag".equals(qName)) {
            String[] containedBy;
            String tagName = attributes.getValue("name");
            Tag tag = this.tagService.getOrCreateTag(tagName);
            if ("true".equals(attributes.getValue("root"))) {
                tag.setIsRoot(true);
            }
            if ("true".equals(attributes.getValue("pseudo"))) {
                tag.setPseudo(true);
            }
            tag.setTitle(attributes.getValue("title"));
            String color = attributes.getValue("color");
            if (color != null) {
                if (color.matches("#\\p{XDigit}{6}")) {
                    tag.setColor(color);
                } else {
                    log.fine("Invalid color, not matching #\\p{XDigit}{6}: " + color);
                }
            }
            if (!this.stack.empty()) {
                this.stack.peek().addContainedTag(tag);
            }
            this.stack.push(tag);
            for (String containingTagName : containedBy = StringUtils.split((String)StringUtils.defaultString((String)attributes.getValue("parents")), (String)" ,")) {
                Tag containingTag = this.tagService.getOrCreateTag(containingTagName);
                tag.addContainingTag(containingTag);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("tag".equals(qName)) {
            this.stack.pop();
        }
    }
}

