/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import org.jboss.windup.config.AbstractConfigurationOption;
import org.jboss.windup.config.InputType;
import org.jboss.windup.config.ValidationResult;
import org.jboss.windup.util.exception.WindupException;

public abstract class AbstractPathConfigurationOption
extends AbstractConfigurationOption {
    private boolean mustExist = false;

    protected AbstractPathConfigurationOption(boolean mustExist) {
        this.mustExist = mustExist;
    }

    @Override
    public Class<?> getType() {
        return File.class;
    }

    protected Path castToPath(Object file) {
        if (file instanceof File) {
            return ((File)file).toPath();
        }
        if (file instanceof Path) {
            return (Path)file;
        }
        throw new WindupException("Unrecognized type: " + file.getClass().getCanonicalName());
    }

    private ValidationResult validatePath(Path path) {
        if (this.mustExist) {
            if (this.getUIType() == InputType.DIRECTORY && !Files.isDirectory(path, new LinkOption[0])) {
                return new ValidationResult(ValidationResult.Level.ERROR, this.getName() + " must exist and be a directory!");
            }
            if (this.getUIType() == InputType.FILE && !Files.isRegularFile(path, new LinkOption[0])) {
                return new ValidationResult(ValidationResult.Level.ERROR, this.getName() + " must exist and be a regular file!");
            }
            if (this.getUIType() == InputType.FILE_OR_DIRECTORY && !Files.exists(path, new LinkOption[0])) {
                return new ValidationResult(ValidationResult.Level.ERROR, this.getName() + " must exist!");
            }
            if (!Files.exists(path, new LinkOption[0])) {
                return new ValidationResult(ValidationResult.Level.ERROR, this.getName() + " must exist!");
            }
        }
        return ValidationResult.SUCCESS;
    }

    @Override
    public ValidationResult validate(Object fileObject) {
        if (fileObject == null && this.isRequired() || fileObject instanceof Collection && this.isRequired() && ((Collection)fileObject).isEmpty()) {
            return new ValidationResult(ValidationResult.Level.ERROR, this.getName() + " must be specified.");
        }
        if (fileObject == null) {
            return ValidationResult.SUCCESS;
        }
        if (fileObject instanceof Iterable && !(fileObject instanceof Path)) {
            for (Object listItem : (Iterable)fileObject) {
                ValidationResult result = this.validatePath(this.castToPath(listItem));
                if (result.getLevel() == ValidationResult.Level.SUCCESS) continue;
                return result;
            }
            return ValidationResult.SUCCESS;
        }
        return this.validatePath(this.castToPath(fileObject));
    }
}

