/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.projecttraversal;

import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.windup.config.AbstractRuleLifecycleListener;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.graph.traversal.ProjectModelTraversal;

public class ProjectTraversalCache
extends AbstractRuleLifecycleListener {
    private static final Map<ProjectModel, SoftReference<Set<ProjectModel>>> projectToApplicationCache = new ConcurrentHashMap<ProjectModel, SoftReference<Set<ProjectModel>>>();

    @Override
    public void beforeExecution(GraphRewrite event) {
        projectToApplicationCache.clear();
    }

    public static Set<ProjectModel> getApplicationsForProject(GraphContext context, ProjectModel project) {
        Set<ProjectModel> results = ProjectTraversalCache.getFromCache(project);
        if (results != null) {
            return results;
        }
        results = new HashSet<ProjectModel>();
        WindupConfigurationModel configurationModel = WindupConfigurationService.getConfigurationModel((GraphContext)context);
        for (FileModel inputFile : configurationModel.getInputPaths()) {
            ProjectModel application = inputFile.getProjectModel();
            ProjectModelTraversal traversal = new ProjectModelTraversal(application);
            Set projectsInApplication = traversal.getAllProjects(true);
            if (!projectsInApplication.contains(project)) continue;
            results.add(application);
        }
        if (results.isEmpty()) {
            results.add(project);
        }
        ProjectTraversalCache.putInCache(project, results);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<ProjectModel> getFromCache(ProjectModel project) {
        if (project == null) {
            return null;
        }
        Map<ProjectModel, SoftReference<Set<ProjectModel>>> map = projectToApplicationCache;
        synchronized (map) {
            SoftReference<Set<ProjectModel>> referenceProjectsSet = projectToApplicationCache.get(project);
            return referenceProjectsSet == null ? null : referenceProjectsSet.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putInCache(ProjectModel project, Set<ProjectModel> projects) {
        if (project == null) {
            return;
        }
        Map<ProjectModel, SoftReference<Set<ProjectModel>>> map = projectToApplicationCache;
        synchronized (map) {
            SoftReference<Set<ProjectModel>> referenceProjectsSet = new SoftReference<Set<ProjectModel>>(projects);
            projectToApplicationCache.put(project, referenceProjectsSet);
        }
    }
}

