/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.tags;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import javax.inject.Singleton;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jboss.windup.config.tags.Tag;
import org.jboss.windup.config.tags.TagsSaxHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Singleton
public class TagService {
    private static final Logger log = Logger.getLogger(TagService.class.getName());
    private ConcurrentMap<String, Tag> definedTags = new ConcurrentHashMap<String, Tag>();

    public void readTags(InputStream tagsXML) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(tagsXML, (DefaultHandler)new TagsSaxHandler(this));
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            throw new RuntimeException("Failed parsing the tags definition: " + ex.getMessage(), ex);
        }
    }

    public Tag getTag(String tagName) {
        return (Tag)this.definedTags.get(tagName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tag getOrCreateTag(String tagName) {
        ConcurrentMap<String, Tag> concurrentMap = this.definedTags;
        synchronized (concurrentMap) {
            if (this.definedTags.containsKey(tagName)) {
                return (Tag)this.definedTags.get(tagName);
            }
            Tag tag = new Tag(tagName);
            this.definedTags.put(tagName, tag);
            return tag;
        }
    }

    public boolean isUnderTag(String superTagName, String subTagName) {
        if (superTagName == null || subTagName == null) {
            return false;
        }
        if (superTagName.equals(subTagName)) {
            return false;
        }
        Tag superTag = this.getTag(superTagName);
        Tag subTag = this.getTag(subTagName);
        return this.isUnderTag(superTag, subTag);
    }

    public boolean isUnderTag(Tag superTag, Tag subTag) {
        LinkedHashSet<Tag> nextSet;
        if (superTag == null || subTag == null) {
            return false;
        }
        if (superTag.getName().equals(subTag.getName())) {
            return false;
        }
        LinkedHashSet walkedSet = new LinkedHashSet();
        LinkedHashSet<Tag> currentSet = new LinkedHashSet<Tag>();
        currentSet.add(subTag);
        do {
            walkedSet.addAll(currentSet);
            nextSet = new LinkedHashSet<Tag>();
            for (Tag currentTag : currentSet) {
                Set<Tag> parentTags = currentTag.getParentTags();
                if (parentTags.contains(superTag)) {
                    return true;
                }
                nextSet.addAll(currentTag.getParentTags());
            }
            for (Tag walkedTag : walkedSet) {
                if (!nextSet.contains(walkedTag)) continue;
                nextSet.remove(walkedTag);
            }
        } while (!(currentSet = nextSet).isEmpty());
        return false;
    }

    public void dumpTagsToJavaScript(Writer writer) throws IOException {
        writer.append("function fillTagService(tagService) {\n");
        writer.append("\t// (name, isRoot, isPseudo, color), [parent tags]\n");
        for (Tag tag : this.definedTags.values()) {
            writer.append("\ttagService.registerTag(new Tag(");
            this.escapeOrNull(tag.getName(), writer);
            writer.append(", ");
            this.escapeOrNull(tag.getTitle(), writer);
            writer.append(", ").append("" + tag.isRoot()).append(", ").append("" + tag.isPseudo()).append(", ");
            this.escapeOrNull(tag.getColor(), writer);
            writer.append(")").append(", [");
            for (Tag parentTag : tag.getParentTags()) {
                writer.append("'").append(StringEscapeUtils.escapeEcmaScript((String)parentTag.getName())).append("',");
            }
            writer.append("]);\n");
        }
        writer.append("}\n");
    }

    private void escapeOrNull(String string, Writer writer) throws IOException {
        if (string == null) {
            writer.append("null");
        } else {
            writer.append('\"').append(StringEscapeUtils.escapeEcmaScript((String)string)).append('\"');
        }
    }

    public String toString() {
        return "TagService{ definedTags: " + this.definedTags.size() + '}';
    }
}

