/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.query;

import com.google.common.collect.Iterables;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.FramedGraphQuery;
import com.tinkerpop.frames.structures.FramedVertexIterable;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import com.tinkerpop.pipes.PipeFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.Variables;
import org.jboss.windup.config.condition.GraphCondition;
import org.jboss.windup.config.query.QueryBuilderAs;
import org.jboss.windup.config.query.QueryBuilderFind;
import org.jboss.windup.config.query.QueryBuilderFrom;
import org.jboss.windup.config.query.QueryBuilderPiped;
import org.jboss.windup.config.query.QueryBuilderWith;
import org.jboss.windup.config.query.QueryGremlinCriterion;
import org.jboss.windup.config.query.QueryPropertyComparisonType;
import org.jboss.windup.config.query.QueryPropertyCriterion;
import org.jboss.windup.config.query.QueryTypeCriterion;
import org.jboss.windup.config.selectors.FramesSelector;
import org.jboss.windup.graph.GraphTypeManager;
import org.jboss.windup.graph.frames.VertexFromFramedIterable;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.Task;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class Query
extends GraphCondition
implements QueryBuilderFind,
QueryBuilderFrom,
QueryBuilderWith,
QueryBuilderPiped {
    private String outputVar = "default";
    private final List<QueryGremlinCriterion> pipelineCriteria = new ArrayList<QueryGremlinCriterion>();
    private Class<? extends WindupVertexFrame> searchType;
    private FramesSelector framesSelector;
    private Predicate<WindupVertexFrame> resultFilter;

    private Query() {
    }

    public static QueryBuilderPiped gremlin(QueryGremlinCriterion criterion) {
        return new Query().piped(criterion);
    }

    public static QueryBuilderFind fromType(Class<? extends WindupVertexFrame> type) {
        Query query = new Query();
        query.searchType = type;
        return query;
    }

    @Override
    public QueryBuilderFind excludingType(final Class<? extends WindupVertexFrame> type) {
        this.pipelineCriteria.add(new QueryGremlinCriterion(){

            @Override
            public void query(GraphRewrite event, GremlinPipeline<Vertex, Vertex> pipeline) {
                pipeline.filter((PipeFunction)new PipeFunction<Vertex, Boolean>(){

                    public Boolean compute(Vertex argument) {
                        return !GraphTypeManager.hasType((Class)type, (Vertex)argument);
                    }
                });
            }
        });
        return this;
    }

    @Override
    public QueryBuilderFind includingType(final Class<? extends WindupVertexFrame> type) {
        this.pipelineCriteria.add(new QueryGremlinCriterion(){

            @Override
            public void query(GraphRewrite event, GremlinPipeline<Vertex, Vertex> pipeline) {
                pipeline.filter((PipeFunction)new PipeFunction<Vertex, Boolean>(){

                    public Boolean compute(Vertex argument) {
                        return GraphTypeManager.hasType((Class)type, (Vertex)argument);
                    }
                });
            }
        });
        return this;
    }

    public static QueryBuilderFrom from(String name) {
        Query query = new Query();
        query.setInputVariablesName(name);
        return query;
    }

    @Override
    public ConditionBuilder as(String name) {
        this.outputVar = name;
        return this;
    }

    @Override
    public boolean evaluate(final GraphRewrite event, final EvaluationContext context) {
        String queryStr = this.toString();
        return (Boolean)ExecutionStatistics.performBenchmarked((String)queryStr, (Task)new Task<Boolean>(){

            public Boolean execute() {
                Iterable resultIterable;
                Query.this.setInitialFramesSelector(Query.createInitialFramesSelector(Query.this));
                Iterable result = resultIterable = Query.this.framesSelector.getFrames(event, context);
                if (Query.this.resultFilter != null) {
                    com.google.common.base.Predicate<WindupVertexFrame> guavaPred = new com.google.common.base.Predicate<WindupVertexFrame>(){

                        public boolean apply(WindupVertexFrame input) {
                            return Query.this.resultFilter.accept((Object)input);
                        }
                    };
                    result = Iterables.filter(result, (com.google.common.base.Predicate)guavaPred);
                }
                Query.this.setResults(event, Query.this.outputVar, result);
                return result.iterator().hasNext();
            }
        });
    }

    @Override
    public QueryBuilderWith withProperty(String property, Object searchValue) {
        return this.withProperty(property, QueryPropertyComparisonType.EQUALS, searchValue);
    }

    @Override
    public QueryBuilderWith withProperty(String property, Iterable<?> values) {
        this.pipelineCriteria.add(new QueryPropertyCriterion(property, QueryPropertyComparisonType.CONTAINS_ANY_TOKEN, values));
        return this;
    }

    @Override
    public QueryBuilderWith withProperty(String property) {
        this.pipelineCriteria.add(new QueryPropertyCriterion(property, QueryPropertyComparisonType.DEFINED, null));
        return this;
    }

    private static FramesSelector createInitialFramesSelector(final Query query) {
        return new FramesSelector(){

            public Iterable<WindupVertexFrame> getFrames(GraphRewrite event, EvaluationContext context) {
                Iterable<Vertex> startingVertices = this.getStartingVertices(event);
                GremlinPipeline pipeline = new GremlinPipeline(startingVertices);
                HashSet<WindupVertexFrame> frames = new HashSet<WindupVertexFrame>();
                for (QueryGremlinCriterion c : query.getPipelineCriteria()) {
                    c.query(event, (GremlinPipeline<Vertex, Vertex>)pipeline);
                }
                FramedVertexIterable framedVertexIterable = new FramedVertexIterable(event.getGraphContext().getFramed(), (Iterable)pipeline, WindupVertexFrame.class);
                for (WindupVertexFrame frame : framedVertexIterable) {
                    frames.add(frame);
                }
                return frames;
            }

            private Iterable<Vertex> getStartingVertices(GraphRewrite event) {
                boolean hasStartingVerticesVariable;
                boolean bl = hasStartingVerticesVariable = query.getInputVariablesName() != null && !query.getInputVariablesName().isEmpty();
                if (hasStartingVerticesVariable) {
                    if (query.searchType != null) {
                        query.piped(new QueryTypeCriterion(query.searchType));
                    }
                    Variables variables = (Variables)event.getRewriteContext().get(Variables.class);
                    Iterable<? extends WindupVertexFrame> frames = variables.findVariable(query.getInputVariablesName());
                    return new VertexFromFramedIterable(frames);
                }
                FramedGraphQuery framesQueryType = event.getGraphContext().getFramed().query();
                if (query.searchType != null) {
                    new QueryTypeCriterion(query.searchType).query(framesQueryType);
                    Iterable startingVertices = framesQueryType.vertices();
                    return startingVertices;
                }
                return event.getGraphContext().getGraph().getVertices();
            }
        };
    }

    @Override
    public QueryBuilderWith withProperty(String property, Object searchValue, Object ... searchValues) {
        LinkedList<Object> values = new LinkedList<Object>();
        values.add(searchValue);
        values.addAll(Arrays.asList(searchValues));
        return this.withProperty(property, values);
    }

    @Override
    public QueryBuilderWith withProperty(String property, QueryPropertyComparisonType searchType, Object searchValue) {
        this.pipelineCriteria.add(new QueryPropertyCriterion(property, searchType, searchValue));
        return this;
    }

    @Override
    public QueryBuilderPiped piped(QueryGremlinCriterion criterion) {
        this.pipelineCriteria.add(criterion);
        return this;
    }

    private void setInitialFramesSelector(FramesSelector selector) {
        this.framesSelector = selector;
    }

    public Collection<QueryGremlinCriterion> getPipelineCriteria() {
        return this.pipelineCriteria;
    }

    @Override
    public <FRAMETYPE extends WindupVertexFrame> QueryBuilderAs filteredBy(Predicate<FRAMETYPE> predicate) {
        this.resultFilter = predicate;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Query");
        if (this.searchType != null) {
            builder.append(".find(").append(this.searchType.getName()).append(")");
        }
        if (!this.pipelineCriteria.isEmpty()) {
            builder.append(".gremlin()");
            for (QueryGremlinCriterion criterion : this.pipelineCriteria) {
                builder.append(criterion);
            }
        }
        builder.append(".as(" + this.outputVar + ")");
        return builder.toString();
    }
}

