/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.metadata;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.windup.config.loader.RuleLoader;
import org.jboss.windup.config.metadata.RuleProviderRegistry;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.GraphContextFactory;

@Singleton
public class RuleProviderRegistryCache {
    private static Logger LOG = Logger.getLogger(RuleProviderRegistryCache.class.getSimpleName());
    private static long MAX_CACHE_AGE = 60000L;
    @Inject
    private GraphContextFactory graphContextFactory;
    @Inject
    private RuleLoader ruleLoader;
    private RuleProviderRegistry cachedRegistry;
    private long cacheRefreshTime;

    public RuleProviderRegistry getRuleProviderRegistry() {
        if (this.cacheValid()) {
            return this.cachedRegistry;
        }
        this.cachedRegistry = null;
        try (GraphContext graphContext = this.graphContextFactory.create();){
            this.cachedRegistry = this.ruleLoader.loadConfiguration(graphContext, null);
            this.cacheRefreshTime = System.currentTimeMillis();
            graphContext.clear();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Failed to load rule information due to: " + e.getMessage(), e);
        }
        return this.cachedRegistry;
    }

    private boolean cacheValid() {
        if (this.cachedRegistry == null) {
            return false;
        }
        long cacheAge = System.currentTimeMillis() - this.cacheRefreshTime;
        return cacheAge < MAX_CACHE_AGE;
    }
}

