/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api.asset;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.logging.Logger;
import junit.framework.Assert;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.junit.Test;

public class ByteArrayAssetTestCase {
    private static final Logger log = Logger.getLogger(ByteArrayAssetTestCase.class.getName());

    @Test
    public void testRoundtripAndExternalMutationGuard() throws Exception {
        int read;
        log.info("testRoundtrip");
        int length = 10;
        byte[] contents = new byte[10];
        for (int i = 0; i < 10; ++i) {
            contents[i] = (byte)i;
        }
        log.info("Inbound contents: " + Arrays.toString(contents));
        ByteArrayAsset asset = new ByteArrayAsset(contents);
        contents[0] = 1;
        log.info("Contents after change: " + Arrays.toString(contents));
        InputStream stream = asset.openStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream(10);
        while ((read = stream.read()) != -1) {
            out.write(read);
        }
        byte[] roundtrip = out.toByteArray();
        log.info("Roundtrip contents: " + Arrays.toString(roundtrip));
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((String)"Roundtrip did not equal passed in contents", (int)i, (int)roundtrip[i]);
        }
    }
}

