/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.skeleton.key.jaxrs;

import java.io.IOException;
import java.security.Principal;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.skeleton.key.RSATokenVerifier;
import org.jboss.resteasy.skeleton.key.ResourceMetadata;
import org.jboss.resteasy.skeleton.key.SkeletonKeyPrincipal;
import org.jboss.resteasy.skeleton.key.SkeletonKeySession;
import org.jboss.resteasy.skeleton.key.VerificationException;
import org.jboss.resteasy.skeleton.key.representations.SkeletonKeyToken;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

@Priority(value=1000)
public class JaxrsBearerTokenFilter
implements ContainerRequestFilter {
    protected ResourceMetadata resourceMetadata;
    private static Logger log = Logger.getLogger(JaxrsBearerTokenFilter.class);
    @Context
    protected SecurityContext securityContext;

    public JaxrsBearerTokenFilter(ResourceMetadata resourceMetadata) {
        this.resourceMetadata = resourceMetadata;
    }

    protected void challengeResponse(ContainerRequestContext request, String error, String description) {
        StringBuilder header = new StringBuilder("Bearer realm=\"");
        header.append(this.resourceMetadata.getRealm()).append("\"");
        if (error != null) {
            header.append(", error=\"").append(error).append("\"");
        }
        if (description != null) {
            header.append(", error_description=\"").append(description).append("\"");
        }
        request.abortWith(Response.status((int)401).header("WWW-Authenticate", (Object)header.toString()).build());
    }

    public void filter(ContainerRequestContext request) throws IOException {
        String authHeader = request.getHeaderString("Authorization");
        if (authHeader == null) {
            this.challengeResponse(request, null, null);
            return;
        }
        String[] split = authHeader.trim().split("\\s+");
        if (split == null || split.length != 2) {
            this.challengeResponse(request, null, null);
        }
        if (!split[0].equalsIgnoreCase("Bearer")) {
            this.challengeResponse(request, null, null);
        }
        String tokenString = split[1];
        try {
            SkeletonKeyToken token = RSATokenVerifier.verifyToken(tokenString, this.resourceMetadata);
            SkeletonKeySession skSession = new SkeletonKeySession(tokenString, this.resourceMetadata);
            ResteasyProviderFactory.pushContext(SkeletonKeySession.class, (Object)skSession);
            String callerPrincipal = this.securityContext.getUserPrincipal() != null ? this.securityContext.getUserPrincipal().getName() : null;
            final SkeletonKeyPrincipal principal = new SkeletonKeyPrincipal(token.getPrincipal(), callerPrincipal);
            final boolean isSecure = this.securityContext.isSecure();
            final SkeletonKeyToken.Access access = this.resourceMetadata.getResourceName() != null ? token.getResourceAccess(this.resourceMetadata.getResourceName()) : token.getRealmAccess();
            SecurityContext ctx = new SecurityContext(){

                public Principal getUserPrincipal() {
                    return principal;
                }

                public boolean isUserInRole(String role) {
                    if (access.getRoles() == null) {
                        return false;
                    }
                    return access.getRoles().contains(role);
                }

                public boolean isSecure() {
                    return isSecure;
                }

                public String getAuthenticationScheme() {
                    return "OAUTH_BEARER";
                }
            };
            request.setSecurityContext(ctx);
        }
        catch (VerificationException e) {
            log.error("Failed to verify token", (Throwable)e);
            this.challengeResponse(request, "invalid_token", e.getMessage());
        }
    }
}

