/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.skeleton.key.representations.idm;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PublicKey;
import org.bouncycastle.openssl.PEMWriter;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.jboss.resteasy.security.PemUtils;

public class PublishedRealmRepresentation {
    protected String realm;
    protected String self;
    @JsonProperty(value="public_key")
    protected String publicKeyPem;
    @JsonProperty(value="authorization")
    protected String authorizationUrl;
    @JsonProperty(value="codes")
    protected String codeUrl;
    @JsonProperty(value="grants")
    protected String grantUrl;
    @JsonIgnore
    protected volatile transient PublicKey publicKey;

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public String getPublicKeyPem() {
        return this.publicKeyPem;
    }

    public void setPublicKeyPem(String publicKeyPem) {
        this.publicKeyPem = publicKeyPem;
        this.publicKey = null;
    }

    @JsonIgnore
    public PublicKey getPublicKey() {
        if (this.publicKey != null) {
            return this.publicKey;
        }
        if (this.publicKeyPem != null) {
            try {
                this.publicKey = PemUtils.decodePublicKey((String)this.publicKeyPem);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.publicKey;
    }

    @JsonIgnore
    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        StringWriter writer = new StringWriter();
        PEMWriter pemWriter = new PEMWriter((Writer)writer);
        try {
            pemWriter.writeObject((Object)publicKey);
            pemWriter.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String s = writer.toString();
        this.publicKeyPem = PemUtils.removeBeginEnd((String)s);
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public void setAuthorizationUrl(String authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
    }

    public String getCodeUrl() {
        return this.codeUrl;
    }

    public void setCodeUrl(String codeUrl) {
        this.codeUrl = codeUrl;
    }

    public String getGrantUrl() {
        return this.grantUrl;
    }

    public void setGrantUrl(String grantUrl) {
        this.grantUrl = grantUrl;
    }
}

