/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.skeleton.key.server;

import java.net.URI;
import java.security.MessageDigest;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.infinispan.Cache;
import org.jboss.resteasy.skeleton.key.keystone.model.StoredUser;
import org.jboss.resteasy.skeleton.key.keystone.model.User;
import org.jboss.resteasy.util.Base64;

@Path(value="/users")
@RolesAllowed(value={"admin"})
public class UsersService {
    private Cache cache;

    public UsersService(Cache cache) {
        this.cache = cache;
    }

    public String create(StoredUser user) throws Exception {
        String password = user.getCredentials().remove("password");
        MessageDigest digest = MessageDigest.getInstance("MD5");
        String hashPassword = Base64.encodeBytes((byte[])digest.digest(password.getBytes("UTF-8")));
        user.getCredentials().clear();
        user.getCredentials().put("password-hash", hashPassword);
        if (user.getId() == null) {
            String id = UUID.randomUUID().toString();
            user.setId(id);
        }
        this.cache.put((Object)("/users/" + user.getId()), (Object)user, -1L, TimeUnit.MILLISECONDS);
        return user.getId();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(@Context UriInfo uriInfo, StoredUser user) throws Exception {
        if (!user.getCredentials().containsKey("password")) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"You did not set a password").type("text/plain").build();
        }
        String id = this.create(user);
        return Response.created((URI)uriInfo.getAbsolutePathBuilder().path(id).build(new Object[0])).entity((Object)user.toUser()).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    public void update(@PathParam(value="id") String id, StoredUser user) throws Exception {
        StoredUser stored = this.getStoredUser(id);
        if (stored == null) {
            throw new NotFoundException();
        }
        if (user.getName() != null) {
            stored.setName(user.getName());
        }
        if (user.getEnabled() != null) {
            stored.setEnabled(user.getEnabled());
        }
        if (user.getEmail() != null) {
            stored.setEmail(user.getEmail());
        }
        if (user.getCredentials() != null && user.getCredentials().containsKey("password")) {
            String password = user.getCredentials().remove("password");
            MessageDigest digest = MessageDigest.getInstance("MD5");
            String hashPassword = Base64.encodeBytes((byte[])digest.digest(password.getBytes("UTF-8")));
            stored.getCredentials().put("password", hashPassword);
        }
        this.cache.put((Object)("/users/" + id), (Object)stored, -1L, TimeUnit.MILLISECONDS);
    }

    @DELETE
    @Path(value="{id}")
    public Response delete(@PathParam(value="id") String id) {
        if (this.cache.containsKey((Object)("/users/" + id))) {
            this.cache.remove((Object)("/users/" + id));
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.GONE).build();
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public User get(@PathParam(value="id") String id) {
        StoredUser user = this.getStoredUser(id);
        if (user == null) {
            throw new NotFoundException();
        }
        return user.toUser();
    }

    public StoredUser getStoredUser(String id) {
        return (StoredUser)this.cache.get((Object)("/users/" + id));
    }
}

