/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.skeleton.key.server;

import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import org.infinispan.Cache;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.security.smime.SignedOutput;
import org.jboss.resteasy.skeleton.key.keystone.model.Access;
import org.jboss.resteasy.skeleton.key.keystone.model.Authentication;
import org.jboss.resteasy.skeleton.key.keystone.model.Project;
import org.jboss.resteasy.skeleton.key.keystone.model.Role;
import org.jboss.resteasy.skeleton.key.keystone.model.Roles;
import org.jboss.resteasy.skeleton.key.keystone.model.StoredUser;
import org.jboss.resteasy.skeleton.key.keystone.model.UrlToken;
import org.jboss.resteasy.skeleton.key.server.ProjectsService;
import org.jboss.resteasy.skeleton.key.server.UsersService;
import org.jboss.resteasy.util.Base64;

@Path(value="/tokens")
public class TokenService {
    private Cache cache;
    private long expiration;
    private TimeUnit expirationUnit;
    private PrivateKey privateKey;
    private X509Certificate certificate;
    private ProjectsService projects;
    private UsersService users;
    private static Logger log = Logger.getLogger(TokenService.class);

    public TokenService(Cache cache, long expiration, TimeUnit expirationUnit, ProjectsService projects, UsersService users) {
        this.cache = cache;
        this.expiration = expiration;
        this.expirationUnit = expirationUnit;
        this.projects = projects;
        this.users = users;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
    }

    @Path(value="signed")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/json"})
    @POST
    public SignedOutput createSigned(Authentication auth) throws Exception {
        if (this.privateKey == null || this.certificate == null) {
            log.warn("privateKey or certificate not set for this operation");
            throw new WebApplicationException(500);
        }
        Access access = this.create(auth);
        SignedOutput signed = new SignedOutput((Object)access, "application/json");
        signed.setPrivateKey(this.privateKey);
        signed.setCertificate(this.certificate);
        return signed;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Access create(Authentication auth) throws Exception {
        String savedPassword;
        String projectId = auth.getProjectId();
        Project project = null;
        if (projectId == null) {
            if (auth.getProjectName() == null) {
                throw new WebApplicationException(401);
            }
            List<Project> list = this.projects.getProjects(auth.getProjectName()).getList();
            if (list.size() != 1) {
                throw new WebApplicationException(401);
            }
            project = list.get(0);
            projectId = project.getId();
        } else {
            project = this.projects.getProject(projectId);
            if (project == null) {
                throw new WebApplicationException(401);
            }
        }
        String userId = auth.getPasswordCredentials().getUser_id();
        if (userId == null) {
            String username = auth.getPasswordCredentials().getUsername();
            if (username == null) {
                throw new WebApplicationException(401);
            }
            userId = this.projects.getUserIdByName(projectId, username);
        }
        if (userId == null) {
            throw new WebApplicationException(401);
        }
        StoredUser user = this.users.getStoredUser(userId);
        if (user == null) {
            throw new WebApplicationException(401);
        }
        String password = auth.getPasswordCredentials().getPassword();
        MessageDigest digest = MessageDigest.getInstance("MD5");
        String hashPassword = Base64.encodeBytes((byte[])digest.digest(password.getBytes("UTF-8")));
        if (!hashPassword.equals(savedPassword = user.getCredentials().get("password-hash"))) {
            throw new WebApplicationException(401);
        }
        Roles roles = this.projects.getUserRoles(projectId, userId);
        if (roles == null || roles.getRoles().size() < 1) {
            throw new WebApplicationException(403);
        }
        String tokenId = UUID.randomUUID().toString();
        long expMillis = this.expirationUnit.toMillis(this.expiration);
        Calendar expires = Calendar.getInstance();
        expires.setTime(new Date(System.currentTimeMillis() + expMillis));
        Access.Token token = new Access.Token(tokenId, expires, project);
        Access.User userInfo = new Access.User(user.getId(), user.getName(), user.getUsername(), roles.getRoles());
        Access access = new Access(token, null, userInfo, null);
        this.cache.put((Object)("/tokens/" + tokenId), (Object)access, this.expiration, this.expirationUnit);
        return access;
    }

    @POST
    @Path(value="url")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public UrlToken createTiny(Authentication auth) throws Exception {
        String savedPassword;
        String projectId = auth.getProjectId();
        Project project = null;
        if (projectId == null) {
            if (auth.getProjectName() == null) {
                throw new WebApplicationException(401);
            }
            List<Project> list = this.projects.getProjects(auth.getProjectName()).getList();
            if (list.size() != 1) {
                throw new WebApplicationException(401);
            }
            project = list.get(0);
            projectId = project.getId();
        } else {
            project = this.projects.getProject(projectId);
            if (project == null) {
                throw new WebApplicationException(401);
            }
        }
        String userId = auth.getPasswordCredentials().getUser_id();
        if (userId == null) {
            String username = auth.getPasswordCredentials().getUsername();
            if (username == null) {
                throw new WebApplicationException(401);
            }
            userId = this.projects.getUserIdByName(projectId, username);
        }
        if (userId == null) {
            throw new WebApplicationException(401);
        }
        StoredUser user = this.users.getStoredUser(userId);
        if (user == null) {
            throw new WebApplicationException(401);
        }
        String password = auth.getPasswordCredentials().getPassword();
        MessageDigest digest = MessageDigest.getInstance("MD5");
        String hashPassword = Base64.encodeBytes((byte[])digest.digest(password.getBytes("UTF-8")));
        if (!hashPassword.equals(savedPassword = user.getCredentials().get("password-hash"))) {
            throw new WebApplicationException(401);
        }
        Roles roles = this.projects.getUserRoles(projectId, userId);
        if (roles == null || roles.getRoles().size() < 1) {
            throw new WebApplicationException(403);
        }
        String tokenId = UUID.randomUUID().toString();
        long expMillis = this.expirationUnit.toMillis(this.expiration);
        Calendar expires = Calendar.getInstance();
        expires.setTime(new Date(System.currentTimeMillis() + expMillis));
        UrlToken tiny = new UrlToken();
        tiny.setUserId(user.getId());
        tiny.setExpires(expires);
        tiny.setProjectId(projectId);
        for (Role role : roles) {
            tiny.getRoles().add(role.getName());
        }
        return tiny;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{token}")
    @RolesAllowed(value={"token-verifier", "admin"})
    public Access get(@PathParam(value="token") String tokenId) throws NotFoundException {
        Access access = (Access)this.cache.get((Object)("/tokens/" + tokenId));
        if (access == null) {
            throw new NotFoundException();
        }
        if (access.getToken().getExpires().getTimeInMillis() < System.currentTimeMillis()) {
            this.cache.remove((Object)("/tokens/" + tokenId));
            throw new NotFoundException();
        }
        return access;
    }
}

