/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.skeleton.key.server;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Context;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.manager.DefaultCacheManager;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.skeleton.key.keystone.model.Mappers;
import org.jboss.resteasy.skeleton.key.server.ProjectsService;
import org.jboss.resteasy.skeleton.key.server.RolesService;
import org.jboss.resteasy.skeleton.key.server.ServerTokenAuthFilter;
import org.jboss.resteasy.skeleton.key.server.TokenService;
import org.jboss.resteasy.skeleton.key.server.UsersService;
import org.jboss.resteasy.spi.ResteasyConfiguration;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class SkeletonKeyApplication {
    public static final String SKELETON_KEY_INFINISPAN_CONFIG_FILE = "skeleton.key.infinispan.config.file";
    public static final String SKELETON_KEY_INFINISPAN_CACHE_NAME = "skeleton.key.infinispan.cache.name";
    Configurable configurable;
    protected Set<Object> singletons = new HashSet<Object>();
    protected PrivateKey privateKey;
    protected X509Certificate certificate;
    protected RolesService roles;
    protected ProjectsService projects;
    protected UsersService users;
    protected TokenService tokenService;
    protected Cache cache;
    protected Logger logger = Logger.getLogger(SkeletonKeyApplication.class);

    public SkeletonKeyApplication(@Context Configurable confgurable) {
        this.configurable = confgurable;
        String exp = this.getConfigProperty("skeleton.key.token.expiration");
        String unit = this.getConfigProperty("skeleton.key.token.expiration.unit");
        long expiration = exp == null ? 30L : Long.parseLong(exp);
        Mappers.registerContextResolver(confgurable);
        this.cache = this.findCache();
        this.users = new UsersService(this.cache);
        this.singletons.add(this.users);
        this.roles = new RolesService(this.cache);
        this.singletons.add(this.roles);
        this.projects = new ProjectsService(this.cache, this.users, this.roles);
        this.singletons.add(this.projects);
        TimeUnit timeUnit = unit == null ? TimeUnit.MINUTES : TimeUnit.valueOf(unit);
        this.tokenService = new TokenService(this.cache, expiration, timeUnit, this.projects, this.users);
        this.singletons.add(this.tokenService);
        this.initKeyPair();
        this.singletons.add(new ServerTokenAuthFilter(this.tokenService));
    }

    protected void initKeyPair() {
        try {
            String keyStoreFile = this.getConfigProperty("skeleton.key.keyStoreFile");
            String keyStorePassword = this.getConfigProperty("skeleton.key.keyStorePassword");
            String alias = this.getConfigProperty("skeleton.key.alias");
            KeyStore keyStore = null;
            if (keyStoreFile == null) {
                String path = this.getConfigProperty("skeleton.key.keyStorePath");
                if (path == null) {
                    this.logger.warn("No key store provided.");
                    return;
                }
                InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
                if (is == null) {
                    throw new RuntimeException("Keystore path invalid: " + path);
                }
                keyStore = KeyStore.getInstance("jks");
                keyStore.load(is, keyStorePassword.toCharArray());
            } else {
                keyStore = KeyStore.getInstance("jks");
                keyStore.load(new FileInputStream(keyStoreFile), keyStorePassword.toCharArray());
            }
            this.privateKey = (PrivateKey)keyStore.getKey(alias, keyStorePassword.toCharArray());
            if (this.privateKey == null) {
                throw new RuntimeException("Private Key is null");
            }
            this.certificate = (X509Certificate)keyStore.getCertificate(alias);
            if (this.certificate == null) {
                throw new RuntimeException("Certificate is null");
            }
            this.tokenService.setPrivateKey(this.privateKey);
            this.tokenService.setCertificate(this.certificate);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RolesService getRoles() {
        return this.roles;
    }

    public ProjectsService getProjects() {
        return this.projects;
    }

    public UsersService getUsers() {
        return this.users;
    }

    public TokenService getTokenService() {
        return this.tokenService;
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }

    protected ResteasyConfiguration getResteasyConfiguration() {
        return (ResteasyConfiguration)ResteasyProviderFactory.getContextData(ResteasyConfiguration.class);
    }

    protected String getConfigProperty(String name) {
        String val = (String)this.configurable.getProperty(name);
        if (val != null) {
            return val;
        }
        ResteasyConfiguration config = this.getResteasyConfiguration();
        if (config == null) {
            return null;
        }
        return config.getParameter(name);
    }

    public Cache getCache() {
        return this.cache;
    }

    protected Cache findCache() {
        Cache cache = (Cache)this.configurable.getProperty("skeleton.key.cache");
        if (cache != null) {
            return cache;
        }
        cache = this.getXmlCache();
        if (cache != null) {
            return cache;
        }
        return this.getDefaultCache();
    }

    protected Cache getDefaultCache() {
        DefaultCacheManager manager = new DefaultCacheManager();
        manager.defineConfiguration("custom-cache", new ConfigurationBuilder().eviction().strategy(EvictionStrategy.NONE).maxEntries(1000).build());
        return manager.getCache("custom-cache");
    }

    protected Cache getXmlCache() {
        String path = this.getConfigProperty(SKELETON_KEY_INFINISPAN_CONFIG_FILE);
        if (path == null) {
            return null;
        }
        String name = this.getConfigProperty(SKELETON_KEY_INFINISPAN_CACHE_NAME);
        if (name == null) {
            throw new RuntimeException("need to specify skeleton.key.infinispan.cache.name");
        }
        try {
            return new DefaultCacheManager(path).getCache(name);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

