/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.skeleton.key.server;

import java.net.URI;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.infinispan.Cache;
import org.jboss.resteasy.skeleton.key.keystone.model.Role;

@Path(value="/roles")
@RolesAllowed(value={"admin"})
public class RolesService {
    private Cache cache;

    public RolesService(Cache cache) {
        this.cache = cache;
    }

    public void create(Role role) throws Exception {
        if (role.getId() == null) {
            String id = UUID.randomUUID().toString();
            role.setId(id);
        }
        this.cache.put((Object)RolesService.roleCacheEntry(role.getId()), (Object)role, -1L, TimeUnit.MILLISECONDS);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(@Context UriInfo uriInfo, Role role) throws Exception {
        this.create(role);
        return Response.created((URI)uriInfo.getAbsolutePathBuilder().path(role.getId()).build(new Object[0])).entity((Object)role).build();
    }

    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public Response create(@Context UriInfo uriInfo, String roleName) throws Exception {
        Role role = new Role();
        role.setName(roleName);
        this.create(role);
        return Response.created((URI)uriInfo.getAbsolutePathBuilder().path(role.getId()).build(new Object[0])).entity((Object)role).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    public void update(@PathParam(value="id") String id, Role role) throws Exception {
        Role storedRole = (Role)this.cache.get((Object)RolesService.roleCacheEntry(id));
        if (storedRole == null) {
            throw new NotFoundException();
        }
        if (role.getName() != null) {
            storedRole.setName(role.getName());
        }
        this.cache.put((Object)RolesService.roleCacheEntry(id), (Object)storedRole, -1L, TimeUnit.MILLISECONDS);
    }

    @DELETE
    @Path(value="{id}")
    public Response delete(@PathParam(value="id") String id) {
        if (this.cache.containsKey((Object)RolesService.roleCacheEntry(id))) {
            this.cache.remove((Object)RolesService.roleCacheEntry(id));
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.GONE).build();
    }

    public static String roleCacheEntry(String id) {
        return "/roles/" + id;
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Role get(@PathParam(value="id") String id) {
        Role storedRole = (Role)this.cache.get((Object)RolesService.roleCacheEntry(id));
        if (storedRole == null) {
            throw new NotFoundException();
        }
        return storedRole;
    }
}

