/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.skeleton.key.server;

import java.net.URI;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.infinispan.Cache;
import org.jboss.resteasy.skeleton.key.keystone.model.Project;
import org.jboss.resteasy.skeleton.key.keystone.model.Projects;
import org.jboss.resteasy.skeleton.key.keystone.model.Role;
import org.jboss.resteasy.skeleton.key.keystone.model.Roles;
import org.jboss.resteasy.skeleton.key.keystone.model.StoredProject;
import org.jboss.resteasy.skeleton.key.keystone.model.User;
import org.jboss.resteasy.skeleton.key.server.RolesService;
import org.jboss.resteasy.skeleton.key.server.UsersService;

@Path(value="/projects")
public class ProjectsService {
    private Cache cache;
    private UsersService usersResource;
    private RolesService rolesResource;
    @Context
    private UriInfo uriInfo;

    public ProjectsService(Cache cache, UsersService usersResource, RolesService rolesResource) {
        this.cache = cache;
        this.usersResource = usersResource;
        this.rolesResource = rolesResource;
    }

    public void createProject(Project project) throws Exception {
        if (project.getId() == null) {
            String id = UUID.randomUUID().toString();
            project.setId(id);
        }
        StoredProject storedProject = new StoredProject(project);
        this.cache.put((Object)ProjectsService.projectCacheId(project.getId()), (Object)storedProject, -1L, TimeUnit.MILLISECONDS);
    }

    @GET
    @Produces(value={"application/json"})
    public Projects getProjects(@QueryParam(value="name") String name) {
        Projects projects = new Projects();
        ArrayList<Project> list = new ArrayList<Project>();
        projects.setList(list);
        for (Object key : this.cache.keySet()) {
            if (!(key instanceof String) || !key.toString().startsWith("/projects/")) continue;
            StoredProject stored = (StoredProject)this.cache.get(key);
            if (stored == null) {
                throw new NotFoundException();
            }
            if (name != null && !name.equals(stored.getProject().getName())) continue;
            list.add(stored.getProject());
        }
        return projects;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"admin"})
    public Response create(Project project) throws Exception {
        this.createProject(project);
        return Response.created((URI)this.uriInfo.getAbsolutePathBuilder().path(project.getId()).build(new Object[0])).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @RolesAllowed(value={"admin"})
    public void update(@PathParam(value="id") String id, Project project) throws Exception {
        StoredProject storedProject = (StoredProject)this.cache.get((Object)ProjectsService.projectCacheId(id));
        if (storedProject == null) {
            throw new NotFoundException();
        }
        Project stored = storedProject.getProject();
        if (project.getName() != null) {
            stored.setName(project.getName());
        }
        if (project.getDescription() != null) {
            stored.setDescription(project.getDescription());
        }
        if (project.getEnabled() != null) {
            stored.setEnabled(project.getEnabled());
        }
        this.cache.put((Object)ProjectsService.projectCacheId(id), (Object)storedProject, -1L, TimeUnit.MILLISECONDS);
    }

    @DELETE
    @Path(value="{id}")
    @RolesAllowed(value={"admin"})
    public Response delete(@PathParam(value="id") String id) {
        if (this.cache.containsKey((Object)ProjectsService.projectCacheId(id))) {
            this.cache.remove((Object)ProjectsService.projectCacheId(id));
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.GONE).build();
    }

    public static String projectCacheId(String id) {
        return "/projects/" + id;
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Project getProject(@PathParam(value="id") String id) {
        StoredProject storedProject = (StoredProject)this.cache.get((Object)ProjectsService.projectCacheId(id));
        if (storedProject == null) {
            throw new NotFoundException();
        }
        return storedProject.getProject();
    }

    public String getUserIdByName(String projectId, String username) {
        StoredProject storedProject = (StoredProject)this.cache.get((Object)ProjectsService.projectCacheId(projectId));
        if (storedProject == null) {
            throw new NotFoundException();
        }
        return storedProject.getUserNameIds().get(username);
    }

    public Roles getUserRoles(String id, String userId) {
        StoredProject storedProject = (StoredProject)this.cache.get((Object)ProjectsService.projectCacheId(id));
        Set<String> roleMapping = storedProject.roleMapping(userId);
        Roles roles = new Roles();
        if (roleMapping == null) {
            return roles;
        }
        for (String roleId : roleMapping) {
            Role role = this.rolesResource.get(roleId);
            if (role == null) continue;
            roles.getRoles().add(role);
        }
        return roles;
    }

    @PUT
    @Path(value="{id}/users/{user}/roles/{role}")
    @RolesAllowed(value={"admin"})
    public void addUserRole(@PathParam(value="id") String id, @PathParam(value="user") String userId, @PathParam(value="role") String roleId) {
        StoredProject storedProject = (StoredProject)this.cache.get((Object)ProjectsService.projectCacheId(id));
        if (storedProject == null) {
            throw new NotFoundException();
        }
        User user = this.usersResource.get(userId);
        Role role = this.rolesResource.get(roleId);
        storedProject.addUserRoleMapping(user, role);
        this.cache.put((Object)ProjectsService.projectCacheId(id), (Object)storedProject, -1L, TimeUnit.MILLISECONDS);
    }

    @DELETE
    @Path(value="{id}/users/{user}/roles/{role}")
    @RolesAllowed(value={"admin"})
    public void removeUserRole(@PathParam(value="id") String id, @PathParam(value="user") String userId, @PathParam(value="role") String roleId) {
        StoredProject storedProject = (StoredProject)this.cache.get((Object)ProjectsService.projectCacheId(id));
        if (storedProject == null) {
            throw new NotFoundException();
        }
        User user = this.usersResource.get(userId);
        Role role = this.rolesResource.get(roleId);
        storedProject.removeUserRoleMapping(user, role);
        this.cache.put((Object)ProjectsService.projectCacheId(id), (Object)storedProject, -1L, TimeUnit.MILLISECONDS);
    }
}

